/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.distributions;

import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.Polynomial;
import edu.northwestern.at.utils.math.distributions.Normal;

public class ErrorFunction {
    protected static double calerf(double x, int jint) {
        double del;
        double ysq;
        double result;
        double XNEG = -26.628;
        double XSMALL = 1.11E-16;
        double XBIG = 26.543;
        double XHUGE = 6.71E7;
        double XMAX = 2.53E307;
        double[] a = new double[]{3.1611237438705655, 113.86415415105016, 377.485237685302, 3209.3775891384694, 0.18577770618460315};
        double[] b = new double[]{23.601290952344122, 244.02463793444417, 1282.6165260773723, 2844.236833439171};
        double[] c = new double[]{0.5641884969886701, 8.883149794388377, 66.11919063714163, 298.6351381974001, 881.952221241769, 1712.0476126340707, 2051.0783778260716, 1230.3393547979972, 2.1531153547440383E-8};
        double[] d = new double[]{15.744926110709835, 117.6939508913125, 537.1811018620099, 1621.3895745666903, 3290.7992357334597, 4362.619090143247, 3439.3676741437216, 1230.3393548037495};
        double[] p = new double[]{0.30532663496123236, 0.36034489994980445, 0.12578172611122926, 0.016083785148742275, 6.587491615298378E-4, 0.016315387137302097};
        double[] q = new double[]{2.568520192289822, 1.8729528499234604, 0.5279051029514285, 0.06051834131244132, 0.0023352049762686918};
        double SQRPI = 0.5641895835477563;
        double THRESH = 0.46875;
        if (Double.isNaN(x)) {
            return x;
        }
        double y = Math.abs(x);
        if (y <= 0.46875) {
            double ysq2 = 0.0;
            if (y > 1.11E-16) {
                ysq2 = y * y;
            }
            double xnum = a[4] * ysq2;
            double xden = ysq2;
            for (int i = 0; i < 3; ++i) {
                xnum = (xnum + a[i]) * ysq2;
                xden = (xden + b[i]) * ysq2;
            }
            double result2 = x * (xnum + a[3]) / (xden + b[3]);
            if (jint != 0) {
                result2 = 1.0 - result2;
            }
            if (jint == 2) {
                result2 *= Math.exp(ysq2);
            }
            return result2;
        }
        if (y <= 4.0) {
            double xnum = c[8] * y;
            double xden = y;
            for (int i = 0; i < 7; ++i) {
                xnum = (xnum + c[i]) * y;
                xden = (xden + d[i]) * y;
            }
            result = (xnum + c[7]) / (xden + d[7]);
            if (jint != 2) {
                ysq = (double)((int)(y * 16.0)) / 16.0;
                del = (y - ysq) * (y + ysq);
                result = Math.exp(-ysq * ysq) * Math.exp(-del) * result;
            }
        } else {
            result = 0.0;
            if (jint == 2 && y >= 6.71E7 && y < 2.53E307) {
                result = 0.5641895835477563 / y;
            } else if (y < 26.543 || jint == 2 && y < 2.53E307) {
                ysq = 1.0 / (y * y);
                double xnum = p[5] * ysq;
                double xden = ysq;
                for (int i = 0; i < 4; ++i) {
                    xnum = (xnum + p[i]) * ysq;
                    xden = (xden + q[i]) * ysq;
                }
                result = ysq * (xnum + p[4]) / (xden + q[4]);
                result = (0.5641895835477563 - result) / y;
                if (jint != 2) {
                    ysq = (double)((int)(y * 16.0)) / 16.0;
                    del = (y - ysq) * (y + ysq);
                    result = Math.exp(-ysq * ysq) * Math.exp(-del) * result;
                }
            }
        }
        if (jint == 0) {
            result = 1.0 - result;
            if (x < 0.0) {
                result = -result;
            }
        } else if (jint == 1) {
            if (x < 0.0) {
                result = 2.0 - result;
            }
        } else if (x < 0.0) {
            if (x < -26.628) {
                result = Double.POSITIVE_INFINITY;
            } else {
                ysq = (double)((int)(x * 16.0)) / 16.0;
                del = (x - ysq) * (x + ysq);
                y = Math.exp(ysq * ysq) * Math.exp(del);
                result = 2.0 * y - result;
            }
        }
        return result;
    }

    public static double errorFunction(double x) {
        return ErrorFunction.calerf(x, 0);
    }

    public static double errorFunctionComplement(double x) {
        return ErrorFunction.calerf(x, 1);
    }

    public static double errorFunctionInverse(double z) {
        return Normal.normalInverse(0.5 * z + 0.5) / Constants.SQRT2;
    }

    public static double errorFunctionInverseBad(double x) {
        double result;
        boolean negative;
        double[] p0 = new double[]{-30.866886527764496, 206.5278640294234, -528.5677083509382, 648.8050954403625, -392.0550990197139, 107.06278097770074, -10.303488455439679, 0.1564151082192386};
        double[] q0 = new double[]{-28.46029017388234, 205.1892414923853, -576.1712509012764, 796.6938817056378, -565.0930556402342, 194.50320483954087, -27.371852306002662, 1.0};
        double[] p1 = new double[]{0.009489736280868109, -0.24758242362823354, 2.5349389220714893, -12.95419898064677, 34.8100577493575, -47.644367129787184, 29.631331505876307, -6.420007150720945, 0.21489185007307063};
        double[] q1 = new double[]{0.006754451277885095, -0.18611650627372178, 2.036929504721635, -11.315360624238055, 33.88017677959514, -53.715373448862145, 41.40999177842889, -12.831383833953227, 1.0};
        boolean bl = negative = x < 0.0;
        if (negative) {
            x = -x;
        }
        if (x >= 1.0) {
            return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if (x > 0.9375) {
            double result2 = ErrorFunction.errorFunctionComplementInverseBad(1.0 - x);
            return negative ? -result2 : result2;
        }
        if (x < 0.75) {
            double xx = x * x - 0.5625;
            result = Polynomial.hornersMethod(p0, xx) / Polynomial.hornersMethod(q0, xx);
        } else {
            double xx = x * x - 0.87890625;
            result = Polynomial.hornersMethod(p1, xx) / Polynomial.hornersMethod(q1, xx);
        }
        return negative ? -result : result;
    }

    public static double errorFunctionComplementInverseBad(double x) {
        boolean negative;
        double BOUNDARY = 1.0 / Math.sqrt(100.0 * Constants.LN10);
        double[] p0 = new double[]{1.9953288964537212E-6, 2.1273702631785955E-4, 0.005897559595240725, 0.05948190145273581, 0.31328289030932666, 1.3630199956442262, 3.415281520565293, 3.0184181468933606, 2.084243354620734, 0.855456350267435, 0.004027391840871289, -1.5196139115744716E-4};
        double[] q0 = new double[]{1.9953210379374213E-6, 2.1274156963404085E-4, 0.0059037062023731355, 0.059959150110861094, 0.3231808308081784, 1.4378337804749344, 3.764457150825797, 4.408143569814384, 4.25087104971828, 2.2127469427969784, 1.0};
        double[] p1 = new double[]{4.53446895632094E-12, 4.615600632134533E-9, 1.2964481560643198E-6, 1.371432956966513E-4, 0.006053791473916219, 0.1127904635363028, 0.828100309044627, 1.950762028758057, 0.6995299060705815};
        double[] q1 = new double[]{4.5344687377088205E-12, 4.615601760093359E-9, 1.2964671850944982E-6, 1.3715891988350204E-4, 0.0060574830550097145, 0.11311889334355782, 0.8400181491817804, 2.1238242087454995, 1.577192238666204, 1.0};
        double y = Math.abs(1.0 - x);
        if (y >= 1.0) {
            return x > 2.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if (x > 1.0) {
            x = 2.0 - x;
            negative = true;
        } else {
            negative = false;
        }
        if (x == 0.0) {
            return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if (x > 0.0625) {
            double result = ErrorFunction.errorFunctionInverseBad(1.0 - x);
            return negative ? -result : result;
        }
        y = 1.0 / Math.sqrt(-Math.log(x));
        double result = y > BOUNDARY ? Polynomial.hornersMethod(p0, y) / Polynomial.hornersMethod(q0, y) / y : Polynomial.hornersMethod(p1, y) / Polynomial.hornersMethod(q1, y) / y;
        return negative ? -result : result;
    }

    protected ErrorFunction() {
    }
}

