/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.distributions;

import edu.northwestern.at.utils.math.Constants;

public class Gamma {
    public static final double MAXGAM = 171.6243769563027;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double gamma(double x) {
        double res;
        double y1;
        double[] p = new double[]{-1.716185138865495, 24.76565080557592, -379.80425647094563, 629.3311553128184, 866.9662027904133, -31451.272968848367, -36144.413418691176, 66456.14382024054};
        double[] q = new double[]{-30.840230011973897, 315.35062697960416, -1015.1563674902192, -3107.771671572311, 22538.11842098015, 4755.846277527881, -134659.9598649693, -115132.25967555349};
        double[] c = new double[]{-0.001910444077728, 8.4171387781295E-4, -5.952379913043012E-4, 7.936507935003503E-4, -0.0027777777777776816, 0.08333333333333333, 0.0057083835261};
        double XBIG = 171.624;
        double XMININ = 2.23E-308;
        if (Double.isNaN(x)) {
            return x;
        }
        boolean parity = false;
        double fact = 1.0;
        int n = 0;
        double y = x;
        if (y <= 0.0) {
            y = -x;
            y1 = (int)y;
            res = y - y1;
            if (res == 0.0) return Double.POSITIVE_INFINITY;
            if (y1 != (double)((int)(y1 * 0.5)) * 2.0) {
                parity = true;
            }
            fact = -Math.PI / Math.sin(Math.PI * res);
            y += 1.0;
        }
        if (y < Constants.MACHEPS) {
            if (!(y >= 2.23E-308)) return Double.POSITIVE_INFINITY;
            res = 1.0 / y;
        } else if (y < 12.0) {
            int i;
            double z;
            y1 = y;
            if (y < 1.0) {
                z = y;
                y += 1.0;
            } else {
                n = (int)(y - 1.0);
                z = (y -= (double)n) - 1.0;
            }
            double xnum = 0.0;
            double xden = 1.0;
            for (i = 0; i < 8; ++i) {
                xnum = (xnum + p[i]) * z;
                xden = xden * z + q[i];
            }
            res = xnum / xden + 1.0;
            if (y1 < y) {
                res /= y1;
            } else if (y1 > y) {
                for (i = 1; i <= n; ++i) {
                    res *= y;
                    y += 1.0;
                }
            }
        } else {
            if (!(y <= 171.624)) return Double.POSITIVE_INFINITY;
            double ysq = y * y;
            double sum = c[6];
            for (int i = 0; i < 6; ++i) {
                sum = sum / ysq + c[i];
            }
            sum = sum / y - y + Constants.LNSQRT2PI;
            res = Math.exp(sum += (y - 0.5) * Math.log(y));
        }
        if (parity) {
            res = -res;
        }
        if (fact == 1.0) return res;
        return fact / res;
    }

    public static double logGamma(double y) {
        double res;
        double PNT68 = 0.6796875;
        double XBIG = 2.5E305;
        double FRTBIG = 2.25E76;
        double d1 = -0.5772156649015329;
        double[] p1 = new double[]{4.945235359296727, 201.8112620856775, 2290.8383738313464, 11319.672059033808, 28557.246356716354, 38484.962284437934, 26377.487876241954, 7225.813979700288};
        double[] q1 = new double[]{67.48212550303778, 1113.3323938571993, 7738.757056935398, 27639.870744033407, 54993.102062261576, 61611.22180066002, 36351.2759150194, 8785.536302431014};
        double d2 = 0.42278433509846713;
        double[] p2 = new double[]{4.974607845568932, 542.4138599891071, 15506.93864978365, 184793.29044456323, 1088204.7694688288, 3338152.96798703, 5106661.678927353, 3074109.0548505397};
        double[] q2 = new double[]{183.03283993705926, 7765.049321445006, 133190.38279660742, 1136705.8213219696, 5267964.117437947, 1.3467014543111017E7, 1.7827365303532742E7, 9533095.591844354};
        double d4 = 1.791759469228055;
        double[] p4 = new double[]{14745.0216605994, 2426813.3694867045, 1.2147555740450932E8, 2.663432449630977E9, 2.940378956634554E10, 1.702665737765399E11, 4.926125793377431E11, 5.606251856223951E11};
        double[] q4 = new double[]{2690.5301758708993, 639388.5654300093, 4.135599930241388E7, 1.120872109616148E9, 1.4886137286788137E10, 1.0168035862724382E11, 3.4174763455073773E11, 4.463158187419713E11};
        double[] c = new double[]{-0.001910444077728, 8.4171387781295E-4, -5.952379913043012E-4, 7.936507935003503E-4, -0.0027777777777776816, 0.08333333333333333, 0.0057083835261};
        if (Double.isNaN(y)) {
            return y;
        }
        if (y > 0.0 && y <= 2.5E305) {
            if (y <= Constants.MACHEPS) {
                res = -Math.log(y);
            } else if (y <= 1.5) {
                double xm1;
                double corr;
                if (y < 0.6796875) {
                    corr = -Math.log(y);
                    xm1 = y;
                } else {
                    corr = 0.0;
                    xm1 = y - 0.5 - 0.5;
                }
                if (y <= 0.5 || y >= 0.6796875) {
                    double xden = 1.0;
                    double xnum = 0.0;
                    for (int i = 0; i < 8; ++i) {
                        xnum = xnum * xm1 + p1[i];
                        xden = xden * xm1 + q1[i];
                    }
                    res = corr + xm1 * (-0.5772156649015329 + xm1 * (xnum / xden));
                } else {
                    double xm2 = y - 0.5 - 0.5;
                    double xden = 1.0;
                    double xnum = 0.0;
                    for (int i = 0; i < 8; ++i) {
                        xnum = xnum * xm2 + p2[i];
                        xden = xden * xm2 + q2[i];
                    }
                    res = corr + xm1 * (0.42278433509846713 + xm2 * (xnum / xden));
                }
            } else if (y <= 4.0) {
                double xm2 = y - 2.0;
                double xden = 1.0;
                double xnum = 0.0;
                for (int i = 0; i < 8; ++i) {
                    xnum = xnum * xm2 + p2[i];
                    xden = xden * xm2 + q2[i];
                }
                res = xm2 * (0.42278433509846713 + xm2 * (xnum / xden));
            } else if (y <= 12.0) {
                double xm4 = y - 4.0;
                double xden = -1.0;
                double xnum = 0.0;
                for (int i = 0; i < 8; ++i) {
                    xnum = xnum * xm4 + p4[i];
                    xden = xden * xm4 + q4[i];
                }
                res = 1.791759469228055 + xm4 * (xnum / xden);
            } else {
                res = 0.0;
                if (y <= 2.25E76) {
                    res = c[6];
                    double ysq = y * y;
                    for (int i = 0; i < 6; ++i) {
                        res = res / ysq + c[i];
                    }
                }
                res /= y;
                double corr = Math.log(y);
                res = res + Constants.LNSQRT2PI - 0.5 * corr;
                res += y * (corr - 1.0);
            }
        } else {
            res = Double.POSITIVE_INFINITY;
        }
        return res;
    }

    public static double incompleteGamma(double x, double alpha, int dPrec, int maxIter) throws IllegalArgumentException {
        double gin;
        double overflow = 1.0E37;
        double minExp = -87.0;
        double[] pn = new double[6];
        if (x == 0.0) {
            return 0.0;
        }
        if (x < 0.0 || alpha <= 0.0) {
            throw new IllegalArgumentException("x<0 or alpha<=0");
        }
        double factor = alpha * Math.log(x) - x - Gamma.logGamma(alpha);
        factor = Math.exp(factor);
        if (dPrec > Constants.MAXPREC) {
            dPrec = Constants.MAXPREC;
        } else if (dPrec <= 0) {
            dPrec = 1;
        }
        double epsz = Math.pow(10.0, -dPrec);
        if (x > 1.0 && x >= alpha) {
            double a = 1.0 - alpha;
            double b = a + x + 1.0;
            double term = 0.0;
            pn[0] = 1.0;
            pn[1] = x;
            pn[2] = x + 1.0;
            pn[3] = x * b;
            gin = pn[2] / pn[3];
            int iter = 0;
            do {
                ++iter;
                double an = (a += 1.0) * (term += 1.0);
                pn[4] = (b += 2.0) * pn[2] - an * pn[0];
                pn[5] = b * pn[3] - an * pn[1];
                if (pn[5] != 0.0) {
                    double rn = pn[4] / pn[5];
                    double dif = Math.abs(gin - rn);
                    if (dif <= epsz && dif <= epsz * rn) break;
                    gin = rn;
                }
                pn[0] = pn[2];
                pn[1] = pn[3];
                pn[2] = pn[4];
                pn[3] = pn[5];
                if (!(Math.abs(pn[4]) >= 1.0E37)) continue;
                pn[0] = pn[0] / 1.0E37;
                pn[1] = pn[1] / 1.0E37;
                pn[2] = pn[2] / 1.0E37;
                pn[3] = pn[3] / 1.0E37;
            } while (iter <= maxIter);
            gin = 1.0 - factor * gin;
        } else {
            int iter = 0;
            gin = 1.0;
            double term = 1.0;
            double a = alpha;
            while (iter <= maxIter && term / (gin += (term *= x / (a += 1.0))) > epsz) {
            }
            gin *= factor / alpha;
        }
        return gin;
    }

    public static double incompleteGamma(double x, double alpha) throws IllegalArgumentException {
        return Gamma.incompleteGamma(x, alpha, Constants.MAXPREC, 1000);
    }

    protected Gamma() {
    }
}

