/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.math.matrix.ColumnTransformation;
import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixFactory;

public class ColumnTransformer {
    public static Matrix applyColumnOperation(Matrix matrix, ColumnTransformation columnTransformation) {
        throw new UnsupportedOperationException("to be implemented");
    }

    public static Matrix sum(Matrix matrix) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        if (rows == 1) {
            return matrix;
        }
        Matrix result = MatrixFactory.createMatrix(1, columns);
        for (int column = 1; column <= columns; ++column) {
            double columnSum = 0.0;
            for (int row = 1; row <= rows; ++row) {
                columnSum += matrix.get(row, column);
            }
            result.set(1, column, columnSum);
        }
        return result;
    }

    public static Matrix product(Matrix matrix) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        if (rows == 1) {
            return matrix;
        }
        Matrix result = MatrixFactory.createMatrix(1, columns);
        for (int column = 1; column <= columns; ++column) {
            double columnProduct = 1.0;
            for (int row = 1; row <= rows && (columnProduct *= matrix.get(row, column)) != 0.0; ++row) {
            }
            result.set(1, column, columnProduct);
        }
        return result;
    }

    public static Matrix mean(Matrix matrix, boolean adjustment) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        int denominator = rows;
        if (adjustment) {
            --denominator;
        }
        if (rows == 1) {
            return matrix;
        }
        Matrix result = MatrixFactory.createMatrix(1, columns);
        for (int column = 1; column <= columns; ++column) {
            double columnSum = 0.0;
            for (int row = 1; row <= rows; ++row) {
                columnSum += matrix.get(row, column);
            }
            result.set(1, column, columnSum / (double)denominator);
        }
        return result;
    }

    public static Matrix max(Matrix matrix) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        if (rows == 1) {
            return matrix;
        }
        Matrix result = MatrixFactory.createMatrix(1, columns);
        for (int column = 1; column <= columns; ++column) {
            double maxValue = matrix.get(1, column);
            for (int row = 2; row <= rows; ++row) {
                maxValue = Math.max(maxValue, matrix.get(row, column));
            }
            result.set(1, column, maxValue);
        }
        return result;
    }

    public static Matrix min(Matrix matrix) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        if (rows == 1) {
            return matrix;
        }
        Matrix result = MatrixFactory.createMatrix(1, columns);
        for (int column = 1; column <= columns; ++column) {
            double minValue = matrix.get(1, column);
            for (int row = 2; row <= rows; ++row) {
                minValue = Math.min(minValue, matrix.get(row, column));
            }
            result.set(1, column, minValue);
        }
        return result;
    }

    protected ColumnTransformer() {
    }
}

