/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.matrix.CholeskyDecomposition;
import edu.northwestern.at.utils.math.matrix.ColumnTransformer;
import edu.northwestern.at.utils.math.matrix.EigenvalueDecomposition;
import edu.northwestern.at.utils.math.matrix.LUDecomposition;
import edu.northwestern.at.utils.math.matrix.MatricesMeasure;
import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixEBEOperation;
import edu.northwestern.at.utils.math.matrix.MatrixEBETransformation;
import edu.northwestern.at.utils.math.matrix.MatrixEBETransformer;
import edu.northwestern.at.utils.math.matrix.MatrixFactory;
import edu.northwestern.at.utils.math.matrix.MatrixFromString;
import edu.northwestern.at.utils.math.matrix.MatrixMeasure;
import edu.northwestern.at.utils.math.matrix.MatrixOperator;
import edu.northwestern.at.utils.math.matrix.MatrixProperty;
import edu.northwestern.at.utils.math.matrix.MatrixToString;
import edu.northwestern.at.utils.math.matrix.MatrixTransformer;
import edu.northwestern.at.utils.math.matrix.QRDecomposition;
import edu.northwestern.at.utils.math.matrix.SingularValueDecomposition;
import edu.northwestern.at.utils.math.statistics.Covar;
import edu.northwestern.at.utils.math.statistics.RankOrder;
import edu.northwestern.at.utils.math.statistics.Standardize;
import java.util.ArrayList;
import java.util.Iterator;

public class Matrices {
    public static int[] bandwidth(Matrix matrix) {
        return MatrixProperty.bandwidth(matrix);
    }

    public static Matrix create(String src) {
        return MatrixFromString.fromMatlabString(src);
    }

    public static Matrix rand(int rows, int cols) {
        return MatrixFactory.createRandomMatrix(rows, cols);
    }

    public static Matrix zeros(int rows, int cols) {
        return MatrixFactory.createMatrix(rows, cols);
    }

    public static Matrix zeros(int size) {
        return Matrices.zeros(size, size);
    }

    public static Matrix ones(int rows, int cols) {
        return MatrixFactory.createMatrix(rows, cols, 1.0);
    }

    public static Matrix ones(int size) {
        return Matrices.ones(size, size);
    }

    public static Matrix eye(int rows, int cols) {
        boolean rowsAreBigger;
        if (rows == cols) {
            return MatrixFactory.createIdentityMatrix(rows);
        }
        boolean bl = rowsAreBigger = rows > cols;
        if (rowsAreBigger) {
            return MatrixOperator.verticalConcatenation(MatrixFactory.createIdentityMatrix(cols), MatrixFactory.createMatrix(rows - cols, cols));
        }
        return MatrixOperator.horizontalConcatenation(MatrixFactory.createIdentityMatrix(rows), MatrixFactory.createMatrix(rows, cols - rows));
    }

    public static Matrix neg(Matrix a) {
        return MatrixTransformer.negate(a);
    }

    public static Matrix sin(Matrix a) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return Math.sin(element);
            }
        });
    }

    public static Matrix cos(Matrix a) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return Math.cos(element);
            }
        });
    }

    public static Matrix exp(Matrix a) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return Math.exp(element);
            }
        });
    }

    public static Matrix log(Matrix a) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return Math.log(element);
            }
        });
    }

    public static Matrix sqrt(Matrix a) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return Math.sqrt(element);
            }
        });
    }

    public static Matrix abs(Matrix a) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return Math.abs(element);
            }
        });
    }

    public static Matrix powElem(Matrix a, final double s) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return Math.pow(element, s);
            }
        });
    }

    public static Matrix powElem(Matrix a, Matrix b) {
        return MatrixOperator.applyEBEOperation(a, b, new MatrixEBEOperation(){

            @Override
            public double apply(double a, double b) {
                return Math.pow(a, b);
            }
        });
    }

    public static Matrix pow(Matrix a, int s) {
        return MatrixTransformer.pow(a, s);
    }

    public static Matrix add(Matrix a, Matrix b) {
        return MatrixOperator.add(a, b);
    }

    public static Matrix add(Matrix a, final double scalar) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return element + scalar;
            }
        });
    }

    public static Matrix subtract(Matrix a, Matrix b) {
        return MatrixOperator.subtract(a, b);
    }

    public static Matrix subtract(Matrix a, final double scalar) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return element - scalar;
            }
        });
    }

    public static Matrix subtract(final double scalar, Matrix a) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return scalar - element;
            }
        });
    }

    public static double dotprod(Matrix a, Matrix b) {
        return MatricesMeasure.dotProduct(a, b);
    }

    public static Matrix multiply(Matrix a, Matrix b) {
        return MatrixOperator.multiply(a, b);
    }

    public static Matrix multiplyEBE(Matrix a, Matrix b) {
        return MatrixOperator.multiplyEBE(a, b);
    }

    public static Matrix multiply(Matrix a, final double scalar) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return scalar * element;
            }
        });
    }

    public static Matrix kron(Matrix a, Matrix b) {
        return MatrixOperator.kroneckerProduct(a, b);
    }

    public static Matrix hdp(Matrix a, Matrix b) {
        return MatrixOperator.horizontalDirectProduct(a, b);
    }

    public static Matrix solve(Matrix a, Matrix b) {
        return MatrixOperator.solve(a, b);
    }

    public static Matrix divide(Matrix a, Matrix b) {
        return MatrixOperator.divideEBE(a, b);
    }

    public static Matrix divide(Matrix a, final double scalar) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return element / scalar;
            }
        });
    }

    public static Matrix divide(final double scalar, Matrix a) {
        return MatrixEBETransformer.ebeTransform(a, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return scalar / element;
            }
        });
    }

    public static Matrix t(Matrix m) {
        return MatrixTransformer.transpose(m);
    }

    public static Matrix transpose(Matrix m) {
        return MatrixTransformer.transpose(m);
    }

    public static Matrix inv(Matrix m) {
        return MatrixTransformer.inverse(m);
    }

    public static Matrix horzcat(Matrix a, Matrix b) {
        return MatrixOperator.horizontalConcatenation(a, b);
    }

    public static Matrix vertcat(Matrix a, Matrix b) {
        return MatrixOperator.verticalConcatenation(a, b);
    }

    public static Matrix blkdiag(ArrayList matrices) {
        Iterator iter = matrices.iterator();
        Matrix tmpMatrix = null;
        while (iter.hasNext()) {
            Matrix matrix = (Matrix)iter.next();
            int rows_m = matrix.rows();
            int cols_m = matrix.columns();
            int rows_tmp = 0;
            int cols_tmp = 0;
            if (tmpMatrix != null) {
                rows_tmp = tmpMatrix.rows();
                cols_tmp = tmpMatrix.columns();
                Matrix rightMatrix = MatrixFactory.createMatrix(rows_tmp, cols_m, 0.0);
                Matrix leftMatrix = MatrixFactory.createMatrix(rows_m, cols_tmp, 0.0);
                Matrix upperMatrix = Matrices.horzcat(tmpMatrix, rightMatrix);
                Matrix lowerMatrix = Matrices.horzcat(leftMatrix, matrix);
                tmpMatrix = Matrices.vertcat(upperMatrix, lowerMatrix);
                continue;
            }
            tmpMatrix = matrix;
        }
        return tmpMatrix;
    }

    public static int rank(Matrix m) {
        return MatrixMeasure.rank(m);
    }

    public static double det(Matrix m) {
        return MatrixMeasure.determinant(m);
    }

    public static double trace(Matrix m) {
        return MatrixMeasure.trace(m);
    }

    public static double norm(Matrix m) {
        return MatrixMeasure.norm2(m);
    }

    public static double norm_1(Matrix m) {
        return MatrixMeasure.norm1(m);
    }

    public static double normInf(Matrix m) {
        return MatrixMeasure.normInfinity(m);
    }

    public static double normFro(Matrix m) {
        return MatrixMeasure.normFrobenius(m);
    }

    public static double cond(Matrix m) {
        return MatrixMeasure.condition(m);
    }

    public static Matrix diag(Matrix m) {
        return MatrixTransformer.diagonal(m);
    }

    public static Matrix diagEx(Matrix m, int offset) {
        return MatrixTransformer.extractDiagonal(m, offset);
    }

    public static Matrix diagEm(Matrix m, int offset) {
        return MatrixTransformer.embedDiagonal(m, offset);
    }

    public static int length(Matrix m) {
        return MatrixMeasure.length(m);
    }

    public static double sumElem(Matrix m) {
        return MatrixMeasure.sum(m);
    }

    public static Matrix sumCol(Matrix m) {
        return ColumnTransformer.sum(m);
    }

    public static double prodElem(Matrix m) {
        return MatrixMeasure.product(m);
    }

    public static Matrix prodCol(Matrix m) {
        return ColumnTransformer.product(m);
    }

    public static double maxElem(Matrix m) {
        return MatrixMeasure.max(m);
    }

    public static Matrix maxCol(Matrix m) {
        return ColumnTransformer.max(m);
    }

    public static double minElem(Matrix m) {
        return MatrixMeasure.min(m);
    }

    public static Matrix minCol(Matrix m) {
        return ColumnTransformer.min(m);
    }

    public static double meanElem(Matrix m) {
        return MatrixMeasure.mean(m, false);
    }

    public static Matrix meanCol(Matrix m) {
        return ColumnTransformer.mean(m, false);
    }

    public static Matrix cumprod(Matrix m) {
        return MatrixTransformer.cumulativeColumnProduct(m);
    }

    public static Matrix cumsum(Matrix m) {
        return MatrixTransformer.cumulativeColumnSum(m);
    }

    public static Matrix triu(Matrix m, int offset) {
        return MatrixTransformer.extractUpperTriangle(m, offset);
    }

    public static Matrix tril(Matrix m, int offset) {
        return MatrixTransformer.extractLowerTriangle(m, offset);
    }

    public static Matrix zeroize(Matrix m) {
        return MatrixTransformer.zeroize(m, Constants.MACHEPS);
    }

    public static Matrix zeroise(Matrix m) {
        return MatrixTransformer.zeroise(m, Constants.MACHEPS);
    }

    public static Matrix[] lu(Matrix m) {
        Matrix[] result = new Matrix[3];
        LUDecomposition lu = new LUDecomposition(m);
        result[0] = lu.getL();
        result[1] = lu.getU();
        result[2] = lu.getPivotMatrix();
        return result;
    }

    public static Matrix[] qr(Matrix m) {
        Matrix[] result = new Matrix[3];
        QRDecomposition qr = new QRDecomposition(m);
        result[0] = qr.getQ();
        result[1] = qr.getR();
        result[2] = qr.getH();
        return result;
    }

    public static Matrix[] eig(Matrix m) {
        Matrix[] result = new Matrix[2];
        EigenvalueDecomposition eig = new EigenvalueDecomposition(m);
        result[0] = eig.getV();
        result[1] = eig.getD();
        return result;
    }

    public static Matrix[] chol(Matrix m) {
        Matrix[] result = new Matrix[2];
        CholeskyDecomposition chol = new CholeskyDecomposition(m);
        result[0] = chol.getL();
        Matrix p = MatrixFactory.createMatrix(1, 1);
        if (chol.isSPD()) {
            p.set(1, 1, 0.0);
        } else {
            p.set(1, 1, 1.0);
        }
        result[1] = p;
        return result;
    }

    public static Matrix[] svd(Matrix m) {
        int mCols;
        Matrix[] result = new Matrix[3];
        int mRows = m.rows();
        if (mRows > (mCols = m.columns())) {
            SingularValueDecomposition svd = new SingularValueDecomposition(m);
            result[0] = svd.getU();
            result[1] = svd.getS();
            result[2] = svd.getV();
        } else {
            SingularValueDecomposition svd = new SingularValueDecomposition(Matrices.transpose(m));
            result[0] = svd.getV();
            result[1] = svd.getS();
            result[2] = svd.getU();
        }
        return result;
    }

    public static void save(String fileName, Matrix matrix) {
        try {
            FileUtils.writeTextFile(fileName, false, MatrixToString.toString(matrix));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Matrix load(String fileName) {
        String matrixString = "";
        try {
            matrixString = FileUtils.readTextFile(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MatrixFromString.fromPlainTextString(matrixString);
    }

    public static Matrix corr(Matrix matrix) {
        return Covar.correlation(matrix);
    }

    public static Matrix cov(Matrix matrix) {
        return Covar.covariance(matrix);
    }

    public static Matrix[] standardize(Matrix matrix) {
        return Standardize.standardize(matrix);
    }

    public static void rankOrderColumns(Matrix matrix) {
        RankOrder.rankOrder(matrix);
    }

    public static Matrix nullSpace(Matrix a) {
        Matrix s;
        int rows = a.rows();
        int cols = a.columns();
        if (rows == 0 && cols == 0) {
            return MatrixFactory.createMatrix(0, 0);
        }
        Matrix[] svda = Matrices.svd(a);
        int srows = svda[1].rows();
        int scols = svda[1].columns();
        if (srows == 1 || scols == 1) {
            s = MatrixFactory.createMatrix(1, 1);
            s.set(1, 1, svda[1].get(1, 1));
        } else {
            s = Matrices.diag(svda[1]);
        }
        double tol = s.get(1, 1) * (double)Matrices.length(a) * Constants.MACHEPS;
        int rank = 0;
        for (int i = 1; i < s.rows(); ++i) {
            if (!(s.get(i, 1) >= tol)) continue;
            ++rank;
        }
        Matrix result = rank < cols ? svda[2].getColumns(rank + 1, cols) : Matrices.zeros(cols, 0);
        return result;
    }

    public static Matrix orthBasis(Matrix a) {
        Matrix s;
        int rows = a.rows();
        int cols = a.columns();
        if (rows == 0 && cols == 0) {
            return MatrixFactory.createMatrix(0, 0);
        }
        Matrix[] svda = Matrices.svd(a);
        int srows = svda[1].rows();
        int scols = svda[1].columns();
        if (srows == 1 || scols == 1) {
            s = MatrixFactory.createMatrix(1, 1);
            s.set(1, 1, svda[1].get(1, 1));
        } else {
            s = Matrices.diag(svda[1]);
        }
        double tol = s.get(1, 1) * (double)Matrices.length(a) * Constants.MACHEPS;
        int rank = 0;
        for (int i = 1; i < s.rows(); ++i) {
            if (!(s.get(i, 1) >= tol)) continue;
            ++rank;
        }
        Matrix result = rank > 0 ? Matrices.neg(svda[2].getColumns(1, rank)) : Matrices.zeros(rows, 0);
        return result;
    }

    protected Matrices() {
    }
}

