/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.math.matrix.DenseMatrix;
import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixConditionalEBETransformation;
import edu.northwestern.at.utils.math.matrix.MatrixEBETransformation;
import edu.northwestern.at.utils.math.matrix.MatrixEBETransformer;
import edu.northwestern.at.utils.math.randomnumbers.RandomVariable;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;

public class MatrixFactory {
    protected static Class defaultMatrixClass = DenseMatrix.class;

    public static Matrix createMatrix(int rows, int columns, Class matrixClass) {
        Matrix result = null;
        Class[] paramTypes = new Class[]{Integer.TYPE, Integer.TYPE};
        Object[] params = new Object[]{new Integer(rows), new Integer(columns)};
        try {
            Constructor constructor = matrixClass.getDeclaredConstructor(paramTypes);
            result = (Matrix)constructor.newInstance(params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Matrix createMatrix(int rows, int columns) {
        return MatrixFactory.createMatrix(rows, columns, defaultMatrixClass);
    }

    public static Matrix createMatrix(int rows, int columns, double scalar, Class matrixClass) {
        final double finalScalar = scalar;
        return MatrixEBETransformer.ebeTransform(MatrixFactory.createMatrix(rows, columns, matrixClass), new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return element + finalScalar;
            }
        });
    }

    public static Matrix createMatrix(int rows, int columns, double scalar) {
        return MatrixFactory.createMatrix(rows, columns, scalar, defaultMatrixClass);
    }

    public static Matrix createMatrix(int rows, int columns, double[][] values, Class matrixClass) {
        Matrix result = MatrixFactory.createMatrix(rows, columns, matrixClass);
        if (result != null) {
            result.set(values);
        }
        return result;
    }

    public static Matrix createMatrix(int rows, int columns, double[][] values) {
        return MatrixFactory.createMatrix(rows, columns, values, defaultMatrixClass);
    }

    public static Matrix createMatrix(double[][] values, Class matrixClass) {
        int nRows = values.length;
        int nColumns = values[0].length;
        return MatrixFactory.createMatrix(nRows, nColumns, values, matrixClass);
    }

    public static Matrix createMatrix(double[][] values) {
        return MatrixFactory.createMatrix(values, defaultMatrixClass);
    }

    public static Matrix createMatrix(List list, Class matrixClass) {
        if (list.size() <= 0) {
            throw new IllegalArgumentException("Array list size should atleast be 1");
        }
        Matrix result = MatrixFactory.createMatrix(list.size(), 1, matrixClass);
        if (result != null) {
            Iterator iter = list.iterator();
            int row = 1;
            while (iter.hasNext()) {
                Double value = (Double)iter.next();
                result.set(row, 1, value);
                ++row;
            }
        }
        return result;
    }

    public static Matrix createMatrix(List list) {
        return MatrixFactory.createMatrix(list, defaultMatrixClass);
    }

    public static Matrix createMatrix(Matrix matrix) {
        Matrix matrixCopy = null;
        if (matrix != null && (matrixCopy = MatrixFactory.createMatrix(matrix.rows(), matrix.columns(), matrix.getClass())) != null) {
            matrixCopy.set(matrix);
        }
        return matrixCopy;
    }

    public static Matrix createIdentityMatrix(int size, Class matrixClass) {
        return MatrixFactory.createScalarMatrix(size, 1.0, matrixClass);
    }

    public static Matrix createIdentityMatrix(int size) {
        return MatrixFactory.createScalarMatrix(size, 1.0);
    }

    public static Matrix createScalarMatrix(int size, final double diagonalValue, Class matrixClass) {
        Matrix matrix = MatrixFactory.createMatrix(size, size, matrixClass);
        return MatrixEBETransformer.ebeTransform(matrix, new MatrixConditionalEBETransformation(){

            @Override
            public double transform(int row, int column, double element) {
                if (row == column) {
                    return diagonalValue;
                }
                return element;
            }
        });
    }

    public static Matrix createScalarMatrix(int size, double diagonalValue) {
        return MatrixFactory.createScalarMatrix(size, diagonalValue, defaultMatrixClass);
    }

    public static Matrix createScalarMatrix(int size, final double[] diagonalValues, Class matrixClass) {
        Matrix matrix = MatrixFactory.createMatrix(size, size, matrixClass);
        return MatrixEBETransformer.ebeTransform(matrix, new MatrixConditionalEBETransformation(){

            @Override
            public double transform(int row, int column, double element) {
                if (row == column && row <= diagonalValues.length) {
                    return diagonalValues[row - 1];
                }
                return element;
            }
        });
    }

    public static Matrix createScalarMatrix(int size, double[] diagonalValues) {
        return MatrixFactory.createScalarMatrix(size, diagonalValues, defaultMatrixClass);
    }

    public static Matrix createRandomMatrix(int rows, int columns, Class matrixClass) {
        return MatrixEBETransformer.ebeTransform(MatrixFactory.createMatrix(rows, columns, matrixClass), new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return RandomVariable.rand();
            }
        });
    }

    public static Matrix createRandomMatrix(int rows, int columns) {
        return MatrixFactory.createRandomMatrix(rows, columns, defaultMatrixClass);
    }

    public static boolean isMatrixClass(Class possibleMatrixClass) {
        boolean result = false;
        block0: for (Class currentClass = possibleMatrixClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Class<?>[] interfaces = currentClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i] != Matrix.class) continue;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    public static Class getDefaultMatrixClass() {
        return defaultMatrixClass;
    }

    public static void setDefaultMatrixClass(Class matrixClass) {
        if (MatrixFactory.isMatrixClass(matrixClass)) {
            defaultMatrixClass = matrixClass;
        }
    }

    protected MatrixFactory() {
    }
}

