/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.math.matrix.ColumnTransformer;
import edu.northwestern.at.utils.math.matrix.LUDecomposition;
import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixEBETransformation;
import edu.northwestern.at.utils.math.matrix.MatrixEBETransformer;
import edu.northwestern.at.utils.math.matrix.MatrixTransformer;
import edu.northwestern.at.utils.math.matrix.RowTransformer;
import edu.northwestern.at.utils.math.matrix.SingularValueDecomposition;

public class MatrixMeasure {
    public static int breadth(Matrix matrix) {
        return Math.min(matrix.rows(), matrix.columns());
    }

    public static double condition(Matrix matrix) {
        return new SingularValueDecomposition(matrix).cond();
    }

    public static double determinant(Matrix matrix) {
        return new LUDecomposition(matrix).det();
    }

    public static int length(Matrix matrix) {
        return Math.max(matrix.rows(), matrix.columns());
    }

    public static double max(Matrix matrix) {
        return RowTransformer.max(ColumnTransformer.max(matrix)).get(1, 1);
    }

    public static double mean(Matrix matrix, boolean adjustment) {
        double prod = matrix.rows() * matrix.columns();
        if (adjustment) {
            return prod / (prod - 1.0) * MatrixMeasure.mean(matrix, false);
        }
        return RowTransformer.mean(ColumnTransformer.mean(matrix, false), false).get(1, 1);
    }

    public static double min(Matrix matrix) {
        return RowTransformer.min(ColumnTransformer.min(matrix)).get(1, 1);
    }

    public static double norm1(Matrix matrix) {
        return RowTransformer.max(ColumnTransformer.sum(MatrixEBETransformer.ebeTransform(matrix, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return Math.abs(element);
            }
        }))).get(1, 1);
    }

    public static double norm2(Matrix matrix) {
        return new SingularValueDecomposition(matrix).norm2();
    }

    public static double normInfinity(Matrix matrix) {
        return ColumnTransformer.max(RowTransformer.sum(MatrixEBETransformer.ebeTransform(matrix, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return Math.abs(element);
            }
        }))).get(1, 1);
    }

    public static double normFrobenius(Matrix matrix) {
        return Math.sqrt(MatrixMeasure.sum(MatrixEBETransformer.ebeTransform(matrix, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return element * element;
            }
        })));
    }

    public static double product(Matrix matrix) {
        return RowTransformer.product(ColumnTransformer.product(matrix)).get(1, 1);
    }

    public static int rank(Matrix matrix) {
        return new SingularValueDecomposition(matrix).rank();
    }

    public static double sum(Matrix matrix) {
        return RowTransformer.sum(ColumnTransformer.sum(matrix)).get(1, 1);
    }

    public static double trace(Matrix matrix) {
        return ColumnTransformer.sum(MatrixTransformer.diagonal(matrix)).get(1, 1);
    }

    protected MatrixMeasure() {
    }
}

