/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.math.matrix.LUDecomposition;
import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixEBEOperation;
import edu.northwestern.at.utils.math.matrix.MatrixEBETransformation;
import edu.northwestern.at.utils.math.matrix.MatrixEBETransformer;
import edu.northwestern.at.utils.math.matrix.MatrixFactory;
import edu.northwestern.at.utils.math.matrix.MatrixMismatchedSizeException;
import edu.northwestern.at.utils.math.matrix.MatrixProperty;
import edu.northwestern.at.utils.math.matrix.QRDecomposition;

public class MatrixOperator {
    public static Matrix applyEBEOperation(Matrix a, Matrix b, MatrixEBEOperation matrixOperation) {
        int rows_a = a.rows();
        int columns_a = a.columns();
        int rows_b = b.rows();
        int columns_b = b.columns();
        if (rows_a != rows_b && columns_a != columns_b) {
            throw new MatrixMismatchedSizeException("Dimensions of a and b do not conform.");
        }
        Matrix result = MatrixFactory.createMatrix(rows_a, columns_a);
        for (int row = 1; row <= rows_a; ++row) {
            for (int column = 1; column <= columns_a; ++column) {
                result.set(row, column, matrixOperation.apply(a.get(row, column), b.get(row, column)));
            }
        }
        return result;
    }

    public static Matrix solve(Matrix x, Matrix b) {
        return MatrixProperty.isSquare(x) ? new LUDecomposition(x).solve(b) : new QRDecomposition(x).solve(b);
    }

    public static Matrix add(Matrix a, Matrix b) {
        return MatrixOperator.applyEBEOperation(a, b, new MatrixEBEOperation(){

            @Override
            public double apply(double a, double b) {
                return a + b;
            }
        });
    }

    public static Matrix subtract(Matrix a, Matrix b) {
        return MatrixOperator.applyEBEOperation(a, b, new MatrixEBEOperation(){

            @Override
            public double apply(double a, double b) {
                return a - b;
            }
        });
    }

    public static Matrix multiply(Matrix a, Matrix b) {
        int rows_a = a.rows();
        int columns_a = a.columns();
        int rows_b = b.rows();
        int columns_b = b.columns();
        if (columns_a != rows_b) {
            throw new MatrixMismatchedSizeException("Dimensions of matrices do not conform for multiplication");
        }
        Matrix result = MatrixFactory.createMatrix(rows_a, columns_b);
        for (int row_a = 1; row_a <= rows_a; ++row_a) {
            for (int column_b = 1; column_b <= columns_b; ++column_b) {
                for (int column_a = 1; column_a <= columns_a; ++column_a) {
                    double sum = 0.0;
                    for (int row_b = 1; row_b <= rows_b; ++row_b) {
                        sum += a.get(row_a, row_b) * b.get(row_b, column_b);
                    }
                    result.set(row_a, column_b, sum);
                }
            }
        }
        return result;
    }

    public static Matrix multiplyEBE(Matrix a, Matrix b) {
        return MatrixOperator.applyEBEOperation(a, b, new MatrixEBEOperation(){

            @Override
            public double apply(double a, double b) {
                return a * b;
            }
        });
    }

    public static Matrix divideEBE(Matrix a, Matrix b) {
        return MatrixOperator.applyEBEOperation(a, b, new MatrixEBEOperation(){

            @Override
            public double apply(double a, double b) {
                double result = 0.0;
                if (b != 0.0) {
                    result = a / b;
                }
                return result;
            }
        });
    }

    public static Matrix horizontalConcatenation(Matrix a, Matrix b) {
        int rows_a = a.rows();
        int cols_a = a.columns();
        int rows_b = b.rows();
        int cols_b = b.columns();
        if (rows_a != rows_b) {
            throw new IllegalArgumentException("Dimensions of a and b don't conform");
        }
        Matrix c = MatrixFactory.createMatrix(rows_a, cols_a + cols_b);
        for (int row = 1; row <= rows_a; ++row) {
            for (int col_a = 1; col_a <= cols_a; ++col_a) {
                c.set(row, col_a, a.get(row, col_a));
            }
            for (int col_b = 1; col_b <= cols_b; ++col_b) {
                c.set(row, cols_a + col_b, b.get(row, col_b));
            }
        }
        return c;
    }

    public static Matrix verticalConcatenation(Matrix a, Matrix b) {
        int rows_a = a.rows();
        int cols_a = a.columns();
        int rows_b = b.rows();
        int cols_b = b.columns();
        if (cols_a != cols_b) {
            throw new IllegalArgumentException("Dimensions of a and b don't conform");
        }
        Matrix c = MatrixFactory.createMatrix(rows_a + rows_b, cols_a);
        for (int col = 1; col <= cols_a; ++col) {
            for (int row_a = 1; row_a <= rows_a; ++row_a) {
                c.set(row_a, col, a.get(row_a, col));
            }
            for (int row_b = 1; row_b <= rows_b; ++row_b) {
                c.set(rows_a + row_b, col, b.get(row_b, col));
            }
        }
        return c;
    }

    public static Matrix kroneckerProduct(Matrix a, Matrix b) {
        Matrix tmpVert = null;
        for (int row = 1; row <= a.rows(); ++row) {
            Matrix horizVert = null;
            for (int col = 1; col <= a.columns(); ++col) {
                final double scalar = a.get(row, col);
                horizVert = horizVert == null ? MatrixEBETransformer.ebeTransform(b, new MatrixEBETransformation(){

                    @Override
                    public double transform(double element) {
                        return scalar * element;
                    }
                }) : MatrixOperator.horizontalConcatenation(horizVert, MatrixEBETransformer.ebeTransform(b, new MatrixEBETransformation(){

                    @Override
                    public double transform(double element) {
                        return scalar * element;
                    }
                }));
            }
            tmpVert = tmpVert == null ? horizVert : MatrixOperator.verticalConcatenation(tmpVert, horizVert);
        }
        return tmpVert;
    }

    public static Matrix horizontalDirectProduct(Matrix a, Matrix b) {
        int rows_b;
        int rows_a = a.rows();
        if (rows_a != (rows_b = b.rows())) {
            throw new IllegalArgumentException("Rows of a and b must be equal");
        }
        Matrix tmpVert = null;
        for (int row = 1; row <= rows_a; ++row) {
            Matrix rowA = a.getRow(row);
            Matrix rowB = b.getRow(row);
            tmpVert = tmpVert == null ? MatrixOperator.kroneckerProduct(rowA, rowB) : MatrixOperator.verticalConcatenation(tmpVert, MatrixOperator.kroneckerProduct(rowA, rowB));
        }
        return tmpVert;
    }

    protected MatrixOperator() {
    }
}

