/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.PrintfFormat;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.math.matrix.Matrix;
import java.util.ArrayList;

public class MatrixToString {
    protected static String defaultStartMatrixString = "";
    protected static String defaultEndMatrixString = "";
    protected static String defaultStartRowString = "";
    protected static String defaultEndRowString = "\n";
    protected static String defaultEndLastRowString = "\n";
    protected static String defaultStartEntryString = " ";
    protected static String defaultEndEntryString = " ";
    protected static String defaultEndLastEntryString = " ";
    protected static String defaultFormatString = "%26.18g";
    public static final int INDIVIDUALWIDTH = 0;
    public static final int MAXIMUMELEMENTWIDTH = 1;
    public static final int FORMATWIDTH = 2;
    protected static int defaultWidthOption = 1;

    public static String toString(Matrix matrix, String title, String[] columnNames, String formatString) {
        return MatrixToString.toString(matrix, title, false, columnNames, false, "", "\n", "", "\n", " ", " ", defaultStartMatrixString, defaultEndMatrixString, defaultStartRowString, defaultEndRowString, defaultEndLastRowString, defaultStartEntryString, defaultEndEntryString, defaultEndLastEntryString, formatString, defaultWidthOption);
    }

    public static String toString(Matrix matrix, String title, String[] columnNames) {
        return MatrixToString.toString(matrix, title, false, columnNames, false, "", "\n", "", "\n", " ", " ", defaultStartMatrixString, defaultEndMatrixString, defaultStartRowString, defaultEndRowString, defaultEndLastRowString, defaultStartEntryString, defaultEndEntryString, defaultEndLastEntryString, defaultFormatString, defaultWidthOption);
    }

    public static String toString(Matrix matrix) {
        return MatrixToString.toString(matrix, null, false, null, false, "", "", "", "", "", "", defaultStartMatrixString, defaultEndMatrixString, defaultStartRowString, defaultEndRowString, defaultEndLastRowString, defaultStartEntryString, defaultEndEntryString, defaultEndLastEntryString, defaultFormatString, defaultWidthOption);
    }

    public static String toString(Matrix matrix, int decimals) {
        String decimalsString = StringUtils.intToString(Math.min(20, Math.max(decimals, 0)));
        return MatrixToString.toString(matrix, null, false, null, false, "", "", "", "", "", "", defaultStartMatrixString, defaultEndMatrixString, defaultStartRowString, defaultEndRowString, defaultEndLastRowString, defaultStartEntryString, defaultEndEntryString, defaultEndLastEntryString, "%26." + decimalsString + "f", defaultWidthOption);
    }

    public static String toMatlabString(Matrix matrix) {
        return MatrixToString.toString(matrix, null, false, null, false, "", "", "", "", "", "", "[", "]", "", "; ", "", " ", ",", "", "%26.18g", 0);
    }

    public static String toGaussString(Matrix matrix) {
        return MatrixToString.toString(matrix, null, false, null, false, "", "", "", "", "", "", "{", "}", "", ", ", "", " ", "", "", "%26.18g", 0);
    }

    public static String toMathMLString(Matrix matrix) {
        return MatrixToString.toString(matrix, null, false, null, false, "", "", "", "", "", "", "<matrix>\n", "</matrix>\n", "<matrixrow>\n", "\n</matrixrow>\n", "\n</matrixrow>\n", "<cn>", "</cn> ", "</cn> ", "%26.18g", 0);
    }

    public static String toXHTMLString(Matrix matrix) {
        return MatrixToString.toString(matrix, null, false, null, false, "", "", "", "", "", "", "<table border=\"1\">\n", "</table>\n", "<tr>\n", "\n</tr>\n", "\n</tr>\n", "<td>", "</td> ", "</td> ", "%26.18g", 0);
    }

    public static String toXHTMLString(Matrix matrix, String title, String[] columnNames) {
        return MatrixToString.toString(matrix, title, true, columnNames, true, "<caption><big>", "</big></caption>\n", "<tr>\n", "\n</tr>\n", "<th>", "</th>", "<table border=\"1\">\n", "</table>\n", "<tr>\n", "\n</tr>\n", "\n</tr>\n", "<td>", "</td> ", "</td> ", "%26.18g", 0);
    }

    public static String toXHTMLString(Matrix matrix, String title, String[] columnNames, int border, String formatString) {
        return MatrixToString.toString(matrix, title, true, columnNames, true, "<caption><big>", "</big></caption>\n", "<tr>\n", "\n</tr>\n", "<th>", "</th>", "<table border=\"" + border + "\">\n", "</table>\n", "<tr>\n", "\n</tr>\n", "\n</tr>\n", "<td>", "</td> ", "</td> ", formatString, 0);
    }

    public static String toString(Matrix matrix, String title, boolean titleEmbedded, String[] columnNames, boolean columnNamesEmbedded, String startTitleString, String endTitleString, String startColumnNamesString, String endColumnNamesString, String startColumnNameString, String endColumnNameString, String startMatrixString, String endMatrixString, String startMatrixRowString, String endMatrixRowString, String endLastMatrixRowString, String startMatrixEntryString, String endMatrixEntryString, String endLastMatrixEntryString, String formatString, int widthOption) {
        String s;
        PrintfFormat format = new PrintfFormat(formatString);
        int maxColWidth = 0;
        if (columnNames != null) {
            for (int i = 0; i < columnNames.length; ++i) {
                maxColWidth = Math.max(maxColWidth, columnNames[i].length());
            }
            if (widthOption == 0) {
                widthOption = 1;
            }
        }
        ArrayList<String> sValues = new ArrayList<String>();
        for (int i = 1; i <= matrix.rows(); ++i) {
            for (int j = 1; j <= matrix.columns(); ++j) {
                double x = matrix.get(i, j);
                s = format.sprintf(x);
                if (widthOption != 2) {
                    s = StringUtils.trim(s);
                }
                sValues.add(new String(s));
                if (s.length() <= maxColWidth) continue;
                maxColWidth = s.length();
            }
        }
        int k = 0;
        StringBuffer sb = new StringBuffer(maxColWidth * matrix.rows() * matrix.columns());
        if (title != null && !titleEmbedded) {
            sb = sb.append(startTitleString);
            sb = sb.append(title);
            sb = sb.append(endTitleString);
        }
        sb = sb.append(startMatrixString);
        if (title != null && titleEmbedded) {
            sb = sb.append(startTitleString);
            sb = sb.append(title);
            sb = sb.append(endTitleString);
        }
        if (columnNames != null) {
            sb = sb.append(startColumnNamesString);
            for (int j = 0; j < Math.min(columnNames.length, matrix.columns()); ++j) {
                sb = sb.append(startColumnNameString);
                sb = sb.append(StringUtils.lpad(columnNames[j], maxColWidth));
                sb = sb.append(endColumnNameString);
            }
            sb = sb.append(endColumnNamesString);
        }
        for (int i = 1; i <= matrix.rows(); ++i) {
            sb = sb.append(startMatrixRowString);
            for (int j = 1; j <= matrix.columns(); ++j) {
                sb = sb.append(startMatrixEntryString);
                s = (String)sValues.get(k++);
                if (widthOption == 1) {
                    s = StringUtils.lpad(s, maxColWidth);
                }
                sb = sb.append(s);
                sb = j < matrix.columns() ? sb.append(endMatrixEntryString) : sb.append(endLastMatrixEntryString);
            }
            sb = i < matrix.rows() ? sb.append(endMatrixRowString) : sb.append(endLastMatrixRowString);
        }
        sb.append(endMatrixString);
        return sb.toString();
    }
}

