/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixEBETransformation;
import edu.northwestern.at.utils.math.matrix.MatrixEBETransformer;
import edu.northwestern.at.utils.math.matrix.MatrixFactory;
import edu.northwestern.at.utils.math.matrix.MatrixMeasure;
import edu.northwestern.at.utils.math.matrix.MatrixMismatchedSizeException;
import edu.northwestern.at.utils.math.matrix.MatrixOperator;
import edu.northwestern.at.utils.math.matrix.MatrixProperty;
import java.util.ArrayList;

public class MatrixTransformer {
    public static Matrix cumulativeColumnProduct(Matrix matrix) {
        Matrix result = MatrixFactory.createMatrix(matrix.rows(), matrix.columns());
        for (int row = 1; row <= matrix.rows(); ++row) {
            for (int col = 1; col <= matrix.columns(); ++col) {
                if (row == 1) {
                    result.set(row, col, matrix.get(row, col));
                    continue;
                }
                result.set(row, col, result.get(row - 1, col) * matrix.get(row, col));
            }
        }
        return result;
    }

    public static Matrix cumulativeColumnSum(Matrix matrix) {
        Matrix result = MatrixFactory.createMatrix(matrix.rows(), matrix.columns());
        for (int row = 1; row <= matrix.rows(); ++row) {
            for (int col = 1; col <= matrix.columns(); ++col) {
                if (row == 1) {
                    result.set(row, col, matrix.get(row, col));
                    continue;
                }
                result.set(row, col, result.get(row - 1, col) + matrix.get(row, col));
            }
        }
        return result;
    }

    public static Matrix diagonal(Matrix matrix) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        Matrix diagonal = null;
        if (rows == 1 && columns == 1) {
            return MatrixFactory.createMatrix(1, 1, matrix.get(1, 1));
        }
        diagonal = MatrixFactory.createMatrix(rows, 1);
        for (int row = 1; row <= rows; ++row) {
            for (int column = 1; column <= columns; ++column) {
                if (row != column) continue;
                diagonal.set(row, 1, matrix.get(row, column));
            }
        }
        return diagonal;
    }

    public static Matrix embedDiagonal(Matrix matrix, int offset) {
        switch (matrix.rows()) {
            case 1: {
                matrix = MatrixTransformer.transpose(matrix);
            }
        }
        switch (matrix.columns()) {
            case 1: {
                int d = Math.abs(offset) + MatrixMeasure.length(matrix);
                Matrix dm = MatrixFactory.createMatrix(d, d);
                if (offset > 0) {
                    for (int row = 1; row <= MatrixMeasure.length(matrix); ++row) {
                        dm.set(row, row + offset, matrix.get(row, 1));
                    }
                } else {
                    for (int row = 1; row <= MatrixMeasure.length(matrix); ++row) {
                        dm.set(row + Math.abs(offset), row, matrix.get(row, 1));
                    }
                }
                return dm;
            }
        }
        throw new MatrixMismatchedSizeException("Matrix must be a row or column vector");
    }

    public static Matrix extractDiagonal(Matrix matrix, int offset) {
        ArrayList<Double> list = new ArrayList<Double>(10);
        if (MatrixProperty.isVector(matrix)) {
            throw new IllegalArgumentException(" Matrix cannot be a vector");
        }
        int length = MatrixMeasure.length(matrix);
        if (offset > 0) {
            for (int row = 1; row <= length - offset; ++row) {
                if (row > matrix.rows() || row + offset > matrix.columns()) continue;
                list.add(new Double(matrix.get(row, row + offset)));
            }
        } else {
            if (length + offset < 1) {
                throw new MatrixMismatchedSizeException("Length of the matrix and offset combined yield invalid matrix indices");
            }
            for (int row = 1; row <= length + offset; ++row) {
                if (row + Math.abs(offset) > matrix.rows() || row > matrix.columns()) continue;
                list.add(new Double(matrix.get(row + Math.abs(offset), row)));
            }
        }
        return MatrixFactory.createMatrix(list);
    }

    public static Matrix extractLowerTriangle(Matrix matrix, int offset) {
        return MatrixOperator.subtract(matrix, MatrixTransformer.extractUpperTriangle(matrix, offset + 1));
    }

    public static Matrix extractUpperTriangle(Matrix matrix, int offset) {
        int column;
        int row;
        int rows = matrix.rows();
        int columns = matrix.columns();
        Matrix result = MatrixFactory.createMatrix(rows, columns);
        for (row = 1; row <= MatrixMeasure.length(matrix) - Math.abs(offset); ++row) {
            for (column = row + Math.abs(offset); column <= MatrixMeasure.length(matrix); ++column) {
                if (row > rows || column > columns) continue;
                result.set(row, column, matrix.get(row, column));
            }
        }
        if (offset < 0) {
            for (row = 1; row <= matrix.rows(); ++row) {
                for (column = Math.max(1, row + offset); column <= Math.min(MatrixMeasure.length(matrix), row - offset - 1); ++column) {
                    if (row > rows || column > columns) continue;
                    result.set(row, column, matrix.get(row, column));
                }
            }
        }
        return result;
    }

    public static Matrix inverse(Matrix matrix) {
        return MatrixOperator.solve(matrix, MatrixFactory.createIdentityMatrix(matrix.rows()));
    }

    public static Matrix negate(Matrix matrix) {
        return MatrixEBETransformer.ebeTransform(matrix, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return -element;
            }
        });
    }

    public static Matrix pow(Matrix matrix, int power) {
        if (MatrixProperty.isSquare(matrix)) {
            if (power <= 0) {
                return MatrixFactory.createMatrix(matrix.rows(), matrix.columns(), 1.0);
            }
            Matrix result = matrix;
            for (int counter = 2; counter <= power; ++counter) {
                result = MatrixOperator.multiply(matrix, result);
            }
            return result;
        }
        throw new MatrixMismatchedSizeException("Matrix must be square");
    }

    public static Matrix transpose(Matrix matrix) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        Matrix result = MatrixFactory.createMatrix(columns, rows);
        for (int row = 1; row <= rows; ++row) {
            for (int column = 1; column <= columns; ++column) {
                result.set(column, row, matrix.get(row, column));
            }
        }
        return result;
    }

    public static Matrix zeroize(Matrix matrix, double tolerance) {
        final double finalTolerance = tolerance;
        return MatrixEBETransformer.ebeTransform(matrix, new MatrixEBETransformation(){

            @Override
            public double transform(double element) {
                return Math.abs(element) <= finalTolerance ? 0.0 : element;
            }
        });
    }

    public static Matrix zeroise(Matrix matrix, double tolerance) {
        return MatrixTransformer.zeroize(matrix, tolerance);
    }

    protected MatrixTransformer() {
    }
}

