/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.math.matrix.AbstractMatrix;
import edu.northwestern.at.utils.math.matrix.Matrix;
import java.util.HashMap;

public class SparseMatrix
extends AbstractMatrix
implements Matrix {
    protected HashMap matrixData;

    protected SparseMatrix() {
    }

    public SparseMatrix(int rows, int columns) {
        super(rows, columns);
        this.matrixData = new HashMap(rows * columns);
    }

    @Override
    public void set(int row, int column, double value) {
        String key = row + ":" + column;
        Object oValue = this.matrixData.get(key);
        if (oValue != null) {
            this.matrixData.remove(key);
        }
        if (value != 0.0) {
            this.matrixData.put(key, new Double(value));
        }
    }

    @Override
    public double get(int row, int column) {
        Object oValue;
        double result = 0.0;
        if (row > 0 && row <= this.rows() && this.columns > 0 && this.columns <= this.columns() && (oValue = this.matrixData.get(row + ":" + column)) != null) {
            result = (Double)oValue;
        }
        return result;
    }

    public int getUsed() {
        return this.matrixData.size();
    }
}

