/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.rootfinders;

import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.MonadicFunction;
import edu.northwestern.at.utils.math.rootfinders.BracketRoot;
import edu.northwestern.at.utils.math.rootfinders.MonadicFunctionRootFinder;
import edu.northwestern.at.utils.math.rootfinders.RootFinderConvergenceTest;
import edu.northwestern.at.utils.math.rootfinders.RootFinderIterationInformation;
import edu.northwestern.at.utils.math.rootfinders.StandardRootFinderConvergenceTest;

public class Bisection
implements MonadicFunctionRootFinder {
    public static double bisection(double x0, double x1, double tol, int maxIter, MonadicFunction function, RootFinderConvergenceTest convergenceTest, RootFinderIterationInformation iterationInformation) throws IllegalArgumentException {
        if (function == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        double f0 = function.f(x0);
        double f1 = function.f(x1);
        if (f0 > 0.0 && f1 > 0.0 || f0 < 0.0 && f1 < 0.0) {
            double[] bracket = new double[]{x0, x1};
            if (!BracketRoot.bracketRoot(bracket, function, maxIter, 1.6)) {
                throw new IllegalArgumentException("Cannot expand interval [x0,x1] to contain root.");
            }
            x0 = bracket[0];
            x1 = bracket[1];
            f0 = function.f(x0);
            f1 = function.f(x1);
        }
        double x = 0.0;
        for (int iter = 0; iter < maxIter; ++iter) {
            x = (x0 + x1) / 2.0;
            double fx = function.f(x);
            if (iterationInformation != null) {
                iterationInformation.iterationInformation(x, fx, Double.NaN, iter);
            }
            if (convergenceTest.converged(x1, x0, fx, tol, tol)) break;
            if (fx * f0 > 0.0) {
                x0 = x;
                f0 = fx;
                continue;
            }
            x1 = x;
            f1 = fx;
        }
        return x;
    }

    public static double bisection(double x0, double x1, double tol, int maxIter, MonadicFunction function) throws IllegalArgumentException {
        return Bisection.bisection(x0, x1, tol, maxIter, function, new StandardRootFinderConvergenceTest(), null);
    }

    public static double bisection(double x0, double x1, MonadicFunction function) throws IllegalArgumentException {
        return Bisection.bisection(x0, x1, Constants.MACHEPS, 250, function, new StandardRootFinderConvergenceTest(), null);
    }

    @Override
    public double findRoot(double x0, double x1, double tol, int maxIter, MonadicFunction function, MonadicFunction derivativeFunction, RootFinderConvergenceTest convergenceTest, RootFinderIterationInformation iterationInformation) throws IllegalArgumentException {
        return Bisection.bisection(x0, x1, tol, maxIter, function, convergenceTest, iterationInformation);
    }
}

