/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.rootfinders;

import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.MonadicFunction;
import edu.northwestern.at.utils.math.rootfinders.BracketRoot;
import edu.northwestern.at.utils.math.rootfinders.MonadicFunctionRootFinder;
import edu.northwestern.at.utils.math.rootfinders.RootFinderConvergenceTest;
import edu.northwestern.at.utils.math.rootfinders.RootFinderIterationInformation;
import edu.northwestern.at.utils.math.rootfinders.StandardRootFinderConvergenceTest;

public class Secant
implements MonadicFunctionRootFinder {
    public static final int PLAIN = 0;
    public static final int FALSEPOSITION = 1;
    public static final int ILLINOIS = 2;

    public static double secant(double x0, double x1, double tol, int maxIter, MonadicFunction function, RootFinderConvergenceTest convergenceTest, RootFinderIterationInformation iterationInformation, int variant) throws IllegalArgumentException {
        double x;
        double fx;
        if (function == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        double f0 = function.f(x0);
        double f1 = function.f(x1);
        if (variant == 1 && (f0 > 0.0 && f1 > 0.0 || f0 < 0.0 && f1 < 0.0)) {
            double[] bracket = new double[]{x0, x1};
            if (!BracketRoot.bracketRoot(bracket, function, maxIter, 1.6)) {
                throw new IllegalArgumentException("Cannot expand interval [x0,x1] to contain root.");
            }
            x0 = bracket[0];
            x1 = bracket[1];
            f0 = function.f(x0);
            f1 = function.f(x1);
        }
        if (Math.abs(f1) < Math.abs(f0)) {
            fx = f0;
            f0 = f1;
            f1 = fx;
            x = x0;
            x0 = x1;
            x1 = x;
        }
        if (f0 == 0.0) {
            return x0;
        }
        for (int iter = 0; iter < maxIter; ++iter) {
            double r = f1 / f0;
            if (Math.abs(1.0 - r) >= Constants.MACHEPS) {
                r /= 1.0 - r;
            }
            x = x1 + r * (x1 - x0);
            fx = function.f(x);
            if (variant == 1) {
                if (fx * f1 <= 0.0) {
                    x0 = x1;
                    x1 = x;
                    f0 = f1;
                    f1 = fx;
                } else {
                    x1 = x;
                    f1 = fx;
                }
            } else if (variant == 2) {
                if (fx * f1 <= 0.0) {
                    x0 = x1;
                    x1 = x;
                    f0 = f1;
                    f1 = fx;
                } else {
                    x1 = x;
                    f0 *= 0.5;
                    f1 = fx;
                }
            } else {
                x0 = x1;
                x1 = x;
                f0 = f1;
                f1 = fx;
            }
            if (iterationInformation != null) {
                iterationInformation.iterationInformation(x1, f1, Double.NaN, iter);
            }
            if (convergenceTest.converged(x1, x0, f1, tol, tol)) break;
        }
        return x1;
    }

    public static double secant(double x0, double x1, double tol, int maxIter, MonadicFunction function, int variant) throws IllegalArgumentException {
        return Secant.secant(x0, x1, tol, maxIter, function, new StandardRootFinderConvergenceTest(), null, variant);
    }

    public static double secant(double x0, double x1, double tol, int maxIter, MonadicFunction function, RootFinderIterationInformation iterationInformation) throws IllegalArgumentException {
        return Secant.secant(x0, x1, tol, maxIter, function, new StandardRootFinderConvergenceTest(), iterationInformation, 2);
    }

    public static double secant(double x0, double x1, double tol, int maxIter, MonadicFunction function) throws IllegalArgumentException {
        return Secant.secant(x0, x1, tol, maxIter, function, new StandardRootFinderConvergenceTest(), null, 2);
    }

    public static double secant(double x0, double x1, MonadicFunction function) throws IllegalArgumentException {
        return Secant.secant(x0, x1, Constants.MACHEPS, 100, function, new StandardRootFinderConvergenceTest(), null, 2);
    }

    @Override
    public double findRoot(double x0, double x1, double tol, int maxIter, MonadicFunction function, MonadicFunction derivativeFunction, RootFinderConvergenceTest convergenceTest, RootFinderIterationInformation iterationInformation) throws IllegalArgumentException {
        return Secant.secant(x0, x1, tol, maxIter, function, convergenceTest, iterationInformation, 2);
    }
}

