/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.statistics;

import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixFactory;

public class Covar {
    public static Matrix covariance(Matrix dataMatrix) {
        int nCols = dataMatrix.columns();
        int nRows = dataMatrix.rows();
        int df = nRows - 1;
        Matrix covarianceMatrix = MatrixFactory.createMatrix(nCols, nCols);
        for (int i = 1; i <= nCols; ++i) {
            for (int j = i; j <= nCols; ++j) {
                int k;
                double crossProduct = 0.0;
                double ssi = 0.0;
                double ssj = 0.0;
                for (k = 1; k <= nRows; ++k) {
                    ssi += dataMatrix.get(k, i);
                    ssj += dataMatrix.get(k, j);
                }
                ssi /= (double)nRows;
                ssj /= (double)nRows;
                for (k = 1; k <= nRows; ++k) {
                    crossProduct += (dataMatrix.get(k, i) - ssi) * (dataMatrix.get(k, j) - ssj);
                }
                covarianceMatrix.set(i, j, crossProduct / (double)df);
                covarianceMatrix.set(j, i, crossProduct / (double)df);
            }
        }
        return covarianceMatrix;
    }

    public static Matrix correlation(Matrix dataMatrix) {
        Matrix covarianceMatrix = Covar.covariance(dataMatrix);
        Matrix correlationMatrix = covarianceMatrix.getCopy();
        for (int i = 1; i <= covarianceMatrix.columns(); ++i) {
            for (int j = i; j <= covarianceMatrix.columns(); ++j) {
                double divisor = Math.sqrt(covarianceMatrix.get(i, i) * covarianceMatrix.get(j, j));
                double corr = divisor != 0.0 ? covarianceMatrix.get(i, j) / divisor : 0.0;
                correlationMatrix.set(i, j, corr);
                correlationMatrix.set(j, i, corr);
            }
        }
        return correlationMatrix;
    }

    protected Covar() {
    }
}

