/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.statistics;

import edu.northwestern.at.utils.math.ArithUtils;
import edu.northwestern.at.utils.math.distributions.Sig;

public class OneWayTable {
    public static double[] pearsonChiSquare(double[] counts) {
        int numCounts = counts.length;
        double sumCounts = 0.0;
        double chiSquare = 0.0;
        double probChiSquare = 1.0;
        for (int i = 0; i < numCounts; ++i) {
            sumCounts += counts[i];
        }
        double expected = 0.0;
        if (numCounts > 0 && (expected = sumCounts / (double)numCounts) > 0.0) {
            for (int i = 0; i < numCounts; ++i) {
                double diff = counts[i] - expected;
                chiSquare += diff * diff / expected;
            }
            probChiSquare = Sig.chisquare(chiSquare, numCounts - 1);
        }
        return new double[]{chiSquare, probChiSquare};
    }

    public static double[] logLikelihoodChiSquare(double[] counts) {
        int numCounts = counts.length;
        double sumCounts = 0.0;
        double chiSquare = 0.0;
        double probChiSquare = 1.0;
        for (int i = 0; i < numCounts; ++i) {
            sumCounts += counts[i];
        }
        double expected = 0.0;
        if (numCounts > 0 && (expected = sumCounts / (double)numCounts) > 0.0) {
            for (int i = 0; i < numCounts; ++i) {
                chiSquare += counts[i] * ArithUtils.safeLog(counts[i] / expected);
            }
            chiSquare = 2.0 * chiSquare;
            probChiSquare = Sig.chisquare(chiSquare, numCounts - 1);
        }
        return new double[]{chiSquare, probChiSquare};
    }

    protected OneWayTable() {
    }
}

