/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.statistics;

import edu.northwestern.at.utils.math.matrix.Matrices;
import edu.northwestern.at.utils.math.matrix.Matrix;

public class PrincipalComponents {
    protected Matrix dataMatrix;
    protected Matrix standardizedDataMatrix;
    protected Matrix correlation;
    protected Matrix eigenVectors;
    protected Matrix eigenValues;
    protected Matrix sqrtEigenValues;
    protected Matrix[] meansAndSDs;
    protected Matrix rowScores;
    protected Matrix columnScores;

    public PrincipalComponents(Matrix dataMatrix) {
        this.dataMatrix = dataMatrix.getCopy();
        this.standardizedDataMatrix = this.dataMatrix.getCopy();
        this.meansAndSDs = Matrices.standardize(this.standardizedDataMatrix);
        this.correlation = Matrices.corr(dataMatrix);
        Matrix[] e = Matrices.eig(this.correlation.getCopy());
        this.eigenVectors = e[0];
        this.eigenValues = Matrices.diag(e[1]);
        int eRows = this.eigenValues.rows();
        for (int i = 1; i <= eRows / 2; ++i) {
            double eig = this.eigenValues.get(i, 1);
            int j = eRows - i + 1;
            this.eigenValues.set(i, 1, this.eigenValues.get(j, 1));
            this.eigenValues.set(j, 1, eig);
            double[] col_i = this.eigenVectors.getColumnData(i);
            this.eigenVectors.setColumnData(i, this.eigenVectors.getColumnData(j));
            this.eigenVectors.setColumnData(j, col_i);
        }
        this.sqrtEigenValues = Matrices.sqrt(this.eigenValues);
        this.rowScores = Matrices.multiply(this.standardizedDataMatrix, this.eigenVectors);
        this.columnScores = Matrices.multiply(this.correlation, this.eigenVectors);
        for (int j = 1; j <= this.columnScores.columns(); ++j) {
            double eigenValue = this.sqrtEigenValues.get(j, 1);
            if (eigenValue != 0.0) {
                eigenValue = 1.0 / eigenValue;
            }
            for (int i = 1; i <= this.columnScores.rows(); ++i) {
                this.columnScores.set(i, j, this.columnScores.get(i, j) * eigenValue);
            }
        }
    }

    public Matrix getDataMatrix() {
        return this.dataMatrix;
    }

    public Matrix getVectors() {
        return this.eigenVectors;
    }

    public Matrix getValues() {
        return this.eigenValues;
    }

    public Matrix getMeans() {
        return this.meansAndSDs[0];
    }

    public Matrix getStandardDeviations() {
        return this.meansAndSDs[1];
    }

    public Matrix getCorrelations() {
        return this.correlation;
    }

    public Matrix getStandardizedDataMatrix() {
        return this.standardizedDataMatrix;
    }

    public Matrix getColumnScores() {
        return this.columnScores;
    }

    public Matrix getRowScores() {
        return this.rowScores;
    }
}

