/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.renderer;

import com.owc.objects.statistics.AbstractChartObject;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.report.Reportable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.util.ShapeUtilities;

public class ChartRenderer
extends AbstractRenderer
implements Reportable {
    private static final String SERIES_KEY_CENSORSHIP = "Censorship";

    public String getName() {
        return "Survival Curve";
    }

    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        AbstractChartObject chartObject = (AbstractChartObject)((Object)renderable);
        ExampleSet set = chartObject.getExampleSet();
        YIntervalSeriesCollection dataSet = new YIntervalSeriesCollection();
        YIntervalSeries seriesSurvival = new YIntervalSeries((Comparable)((Object)"Kaplan-Meier"));
        dataSet.addSeries(seriesSurvival);
        YIntervalSeries seriesCensorship = new YIntervalSeries((Comparable)((Object)SERIES_KEY_CENSORSHIP));
        dataSet.addSeries(seriesCensorship);
        Attribute censorshipAttribute = set.getAttributes().get("IsCensored");
        Attribute valueAttribute = set.getAttributes().get("KaplanMeier");
        Attribute valueUpperLimitAttribute = set.getAttributes().get("UpperConfidenceInterval");
        Attribute valueLowerLimitAttribute = set.getAttributes().get("LowerConfidenceInterval");
        Attribute timeAttribute = set.getAttributes().get("Time");
        for (Example example : set) {
            double time = example.getValue(timeAttribute);
            double value = example.getValue(valueAttribute);
            if (!Double.isNaN(example.getValue(censorshipAttribute))) {
                seriesCensorship.add(time, value, value, value);
            }
            seriesSurvival.add(time, value, example.getValue(valueLowerLimitAttribute), example.getValue(valueUpperLimitAttribute));
        }
        JFreeChart chart = ChartFactory.createXYStepChart((String)"Kaplan-Meier Survival Curve", (String)"Time", (String)"Percent Survival", (XYDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYStepRenderer renderer = new XYStepRenderer();
        renderer.setStepPoint(0.0);
        renderer.setSeriesShape(1, ShapeUtilities.createRegularCross((float)50.0f, (float)5.0f));
        renderer.setSeriesItemLabelsVisible(1, true);
        renderer.setSeriesPaint(1, (Paint)new Color(255, 255, 255, 0));
        renderer.setBaseShapesVisible(true);
        chart.getXYPlot().setRenderer(0, (XYItemRenderer)renderer);
        return new ChartPanel(chart);
    }

    public Reportable createReportable(Object renderable, IOContainer ioContainer, int desiredWidth, int desiredHeight) {
        return null;
    }
}

