/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.renderer;

import com.owc.objects.JSONSerializableIOObject;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.renderer.DefaultReadable;
import com.rapidminer.gui.renderer.NonGraphicalRenderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.report.Reportable;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;

public class JSONRenderer
extends NonGraphicalRenderer {
    public String getName() {
        return "JSON View";
    }

    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        JEditorPane resultText = new JEditorPane();
        resultText.setContentType("text/html");
        resultText.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        resultText.setEditable(false);
        resultText.setBackground(Colors.WHITE);
        if (renderable instanceof JSONSerializableIOObject) {
            String str;
            JSONSerializableIOObject result = (JSONSerializableIOObject)renderable;
            try {
                str = Tools.escapeHTML((String)result.serializeAsJSON());
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                str = sw.toString();
            }
            resultText.setText("<html><pre>" + str + "</pre></html>");
        } else {
            String str = Tools.escapeHTML((String)renderable.toString());
            resultText.setText("<html><h1>" + renderable.getClass().getSimpleName() + "</h1><pre>Object not suitable for JSON View</pre></html>");
        }
        ExtendedJScrollPane sp = new ExtendedJScrollPane((Component)resultText);
        sp.setBorder(null);
        return sp;
    }

    public Reportable createReportable(Object renderable, IOContainer ioContainer) {
        return new DefaultReadable(renderable.toString());
    }
}

