/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.descriptive;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.Arrays;
import java.util.List;

public class HistogramOperator
extends LicensedOperator {
    private static final String ATTRIBUTE_BIN = "bin";
    private static final String ATTRIBUTE_BIN_LOWER_BOUNDARY = "lower_boundary_inclusive";
    private static final String ATTRIBUTE_BIN_UPPER_BOUNDARY = "upper_boundary_exclusive";
    private static final String ATTRIBUTE_BIN_FREQUENCY = "frequency";
    private static final String ATTRIBUTE_ATTRIBUTE = "attribute";
    public static final String PARAMETER_BINS = "bins";
    public static final String PARAMETER_USE_WEIGHT = "use_weight";
    private static final ExampleSetCreator RESULT_MD_CREATOR = new ExampleSetCreator(new String[]{"attribute", "bin", "frequency", "lower_boundary_inclusive", "upper_boundary_exclusive"}, new int[]{7, 3, 4, 4, 4});
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private final OutputPort statisticsOutput = (OutputPort)this.getOutputPorts().createPort("statistics");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private final AttributeSubsetSelector attributeSubsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInput, new int[]{2});

    public HistogramOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition((Precondition)new ExampleSetPrecondition(this.exampleSetInput));
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.statisticsOutput, RESULT_MD_CREATOR.getMetaData()));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        ExampleSet set = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        if (!isLicensed && set.size() > 1000) {
            throw new UserError((Operator)this, "statistics.license_exceeded_data_size", new Object[]{1000});
        }
        int noBins = this.getParameterAsInt(PARAMETER_BINS);
        boolean useWeights = this.getParameterAsBoolean(PARAMETER_USE_WEIGHT);
        Attribute weightAttribute = set.getAttributes().getWeight();
        if (weightAttribute == null) {
            useWeights = false;
        }
        ExampleSetCreator result = new ExampleSetCreator(new String[]{ATTRIBUTE_ATTRIBUTE, ATTRIBUTE_BIN, ATTRIBUTE_BIN_FREQUENCY, ATTRIBUTE_BIN_LOWER_BOUNDARY, ATTRIBUTE_BIN_UPPER_BOUNDARY}, new int[]{7, 3, 4, 4, 4});
        ExampleSet subset = this.attributeSubsetSelector.getSubset(set, false);
        subset.recalculateAllAttributeStatistics();
        double[] frequencies = new double[noBins];
        double[] lowerBoundsInclusive = new double[noBins];
        double[] upperBounds = new double[noBins];
        for (Attribute attribute : subset.getAttributes()) {
            Arrays.fill(frequencies, 0.0);
            if (!attribute.isNumerical()) {
                throw new UserError((Operator)this, 144, new Object[]{attribute.getName(), this.getName()});
            }
            double maxValue = subset.getStatistics(attribute, "maximum");
            double minValue = subset.getStatistics(attribute, "minimum");
            double stepSize = (maxValue - minValue) / (double)noBins;
            double value = minValue;
            for (int i = 0; i < noBins; ++i) {
                lowerBoundsInclusive[i] = value;
                upperBounds[i] = value += stepSize;
            }
            for (Example example : subset) {
                int bin;
                value = example.getValue(attribute);
                double weight = 1.0;
                if (useWeights) {
                    weight = example.getValue(weightAttribute);
                }
                if ((bin = Arrays.binarySearch(lowerBoundsInclusive, value)) >= 0) {
                    int n = bin;
                    frequencies[n] = frequencies[n] + weight;
                    continue;
                }
                int n = -bin - 2;
                frequencies[n] = frequencies[n] + weight;
            }
            if (!this.statisticsOutput.isConnected()) continue;
            for (int bin = 0; bin < noBins; ++bin) {
                result.setValue(ATTRIBUTE_ATTRIBUTE, attribute.getName());
                result.setValue(ATTRIBUTE_BIN, bin + 1);
                result.setValue(ATTRIBUTE_BIN_FREQUENCY, frequencies[bin]);
                result.setValue(ATTRIBUTE_BIN_LOWER_BOUNDARY, lowerBoundsInclusive[bin]);
                result.setValue(ATTRIBUTE_BIN_UPPER_BOUNDARY, upperBounds[bin]);
                result.commit();
            }
        }
        this.exampleSetOutput.deliver((IOObject)set);
        this.statisticsOutput.deliver((IOObject)result.finish());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSubsetSelector.getParameterTypes());
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_BINS, "Specifies how many bins should be used to compute the histogram.", 2, Integer.MAX_VALUE, 100, false);
        types.add((ParameterType)type);
        type = new ParameterTypeBoolean(PARAMETER_USE_WEIGHT, "Specifies whether rows should be counted with their weight or just having all an equal weight of 1.", false, false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

