/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.descriptive.curve;

import com.owc.license.ProductInformation;
import com.owc.objects.statistics.SurvivalCurveChartObject;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeParameterPrecondition;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.Iterator;
import java.util.List;

public class KaplanMeierEstimationOperator
extends LicensedOperator {
    public static final String ATTRIBUTE_TIME = "Time";
    private static final String ATTRIBUTE_UNDER_RISK = "UnderRisk";
    public static final String ATTRIBUTE_IS_CENSORED = "IsCensored";
    public static final String ATTRIBUTE_KAPLAN_MEIER = "KaplanMeier";
    private static final String ATTRIBUTE_VARIANCE = "Variance";
    private static final String ATTRIBUTE_STANDARD_ERROR = "StandardError";
    public static final String ATTRIBUTE_UPPER_CONFIDENCE_INTERVAL = "UpperConfidenceInterval";
    public static final String ATTRIBUTE_LOWER_CONFIDENCE_INTERVAL = "LowerConfidenceInterval";
    public static final String ATTRIBUTE_EVENT = "Event";
    public static final String ATTRIBUTE_CENSORED = "Censored";
    private static String[] TABLE_HEADER_NAMES = new String[]{"Time", "UnderRisk", "Event", "Censored", "IsCensored", "Variance", "StandardError", "LowerConfidenceInterval", "UpperConfidenceInterval", "KaplanMeier"};
    private static int[] TABLE_HEADER_TYPES = new int[]{2, 3, 3, 3, 6, 4, 4, 4, 4, 4};
    public static final String PARAMETER_TIME_ATTRIBUTE = "time_attribute";
    public static final String PARAMETER_EVENT_ATTRIBUTE = "event_attribute";
    public static final String PARAMETER_EVENT_VALUE = "event_value";
    public static final String PARAMETER_CENSOR_VALUE = "censoring_value";
    public static final String PARAMETER_SPECIFY_GROUP_SIZE = "specify_group_size";
    public static final String PARAMETER_GROUP_SIZE = "group_size";
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set input", ExampleSet.class);
    private final OutputPort curveOutput = (OutputPort)this.getOutputPorts().createPort("chart output");
    private final OutputPort curveTableOutput = (OutputPort)this.getOutputPorts().createPort("curve table output");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private ExampleSetCreator exampleSetCreator = new ExampleSetCreator(TABLE_HEADER_NAMES, TABLE_HEADER_TYPES);

    public KaplanMeierEstimationOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInput, (Operator)this, PARAMETER_EVENT_ATTRIBUTE));
        this.exampleSetInput.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInput, (Operator)this, PARAMETER_TIME_ATTRIBUTE));
        this.getTransformer().addGenerationRule(this.curveOutput, SurvivalCurveChartObject.class);
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.curveTableOutput, this.exampleSetCreator.getMetaData()));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        ExampleSet set = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        if (!isLicensed && set.size() > 100) {
            throw new UserError((Operator)this, "statistics.license_exceeded_data_size", new Object[]{100});
        }
        String timeAttributeName = this.getParameterAsString(PARAMETER_TIME_ATTRIBUTE);
        String eventAttributeName = this.getParameterAsString(PARAMETER_EVENT_ATTRIBUTE);
        Attribute timeAttribute = set.getAttributes().get(timeAttributeName);
        if (timeAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{timeAttributeName});
        }
        SortedExampleSet sortedSet = new SortedExampleSet(set, timeAttribute, 0);
        timeAttribute = sortedSet.getAttributes().get(timeAttributeName);
        Attribute eventAttribute = sortedSet.getAttributes().get(eventAttributeName);
        if (timeAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{timeAttributeName});
        }
        if (!timeAttribute.isNumerical() || timeAttribute.isDateTime()) {
            throw new UserError((Operator)this, 144, new Object[]{timeAttributeName, this.getName()});
        }
        if (eventAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{eventAttributeName});
        }
        double eventValue = 0.0;
        double censorValue = 0.0;
        if (eventAttribute.isNumerical()) {
            eventValue = this.getParameterAsDouble(PARAMETER_EVENT_VALUE);
            censorValue = this.getParameterAsDouble(PARAMETER_CENSOR_VALUE);
        } else {
            eventValue = eventAttribute.getMapping().getIndex(this.getParameterAsString(PARAMETER_EVENT_VALUE));
            if (eventValue == -1.0) {
                throw new UserError((Operator)this, "statistics.8", new Object[]{eventAttributeName, this.getName(), PARAMETER_EVENT_VALUE});
            }
            censorValue = eventAttribute.getMapping().getIndex(this.getParameterAsString(PARAMETER_CENSOR_VALUE));
            if (censorValue == -1.0) {
                throw new UserError((Operator)this, "statistics.8", new Object[]{eventAttributeName, this.getName(), PARAMETER_CENSOR_VALUE});
            }
        }
        boolean specifyGroupSize = this.getParameterAsBoolean(PARAMETER_SPECIFY_GROUP_SIZE);
        ExampleSetCreator creator = this.exampleSetCreator.getInstance();
        double n = !specifyGroupSize ? (double)sortedSet.size() : (double)this.getParameterAsInt(PARAMETER_GROUP_SIZE);
        double c = 0.0;
        double s = 1.0;
        double lastTime = -1.0;
        double d = 0.0;
        double currentVarianceSum = 0.0;
        boolean isCensored = false;
        boolean lastExample = false;
        Iterator iteratorSortedSet = sortedSet.iterator();
        Example example = null;
        while (iteratorSortedSet.hasNext() || lastExample) {
            double value;
            double time;
            if (!lastExample) {
                example = (Example)iteratorSortedSet.next();
            }
            if ((time = example.getValue(timeAttribute)) != lastTime && lastTime != -1.0 || lastExample) {
                if (n - d == 0.0 || n == 0.0) {
                    s = 0.0;
                    currentVarianceSum = 0.0;
                } else {
                    s *= (n - d) / n;
                    currentVarianceSum += d / (n * (n - d));
                }
                double var = s * s * currentVarianceSum;
                double se = s * Math.sqrt(currentVarianceSum);
                double lowerLimit = Math.max(0.0, s - 1.96 * se);
                double upperLimit = Math.min(1.0, s + 1.96 * se);
                creator.setValue(ATTRIBUTE_TIME, lastTime);
                creator.setValue(ATTRIBUTE_UNDER_RISK, n);
                creator.setValue(ATTRIBUTE_CENSORED, c);
                creator.setValue(ATTRIBUTE_EVENT, d);
                creator.setValue(ATTRIBUTE_KAPLAN_MEIER, s);
                creator.setValue(ATTRIBUTE_VARIANCE, var);
                creator.setValue(ATTRIBUTE_STANDARD_ERROR, se);
                creator.setValue(ATTRIBUTE_LOWER_CONFIDENCE_INTERVAL, lowerLimit);
                creator.setValue(ATTRIBUTE_UPPER_CONFIDENCE_INTERVAL, upperLimit);
                creator.setValue(ATTRIBUTE_IS_CENSORED, isCensored);
                creator.commit();
                n = n - c - d;
                c = 0.0;
                d = 0.0;
                isCensored = false;
            }
            if ((value = example.getValue(eventAttribute)) == eventValue) {
                d += 1.0;
            } else if (value == censorValue) {
                c += 1.0;
                isCensored = true;
            }
            lastTime = time;
            if (!iteratorSortedSet.hasNext() && !lastExample) {
                lastExample = true;
                continue;
            }
            lastExample = false;
        }
        ExampleSet curveTable = creator.finish();
        String title = "Kaplan- Meier Estimator";
        String domainName = "time";
        String rangeName = "survived percentage";
        this.curveOutput.deliver((IOObject)new SurvivalCurveChartObject(curveTable, title, ATTRIBUTE_KAPLAN_MEIER, ATTRIBUTE_TIME, ATTRIBUTE_IS_CENSORED, ATTRIBUTE_LOWER_CONFIDENCE_INTERVAL, ATTRIBUTE_UPPER_CONFIDENCE_INTERVAL, true, domainName, rangeName));
        this.exampleSetOutput.deliver((IOObject)set);
        this.curveTableOutput.deliver((IOObject)curveTable);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_TIME_ATTRIBUTE, "Select the time attribute of your study. This should uniformly deliver the point in time after start of the study for each object. Be careful with absolute values, if different objects started at different times.", this.exampleSetInput, false, new int[]{2});
        types.add((ParameterType)type);
        type = new ParameterTypeAttribute(PARAMETER_EVENT_ATTRIBUTE, "Select the attribute that contains a flag whether an object of the study caused an event or whether it was censored. Notice that you need to specify the values below. All not specified values will be ignored.", this.exampleSetInput, false, new int[]{0});
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeString(PARAMETER_EVENT_VALUE, "This is the value that indicates that an object received an event.", false));
        types.add((ParameterType)new ParameterTypeString(PARAMETER_CENSOR_VALUE, "This is the value that indicates that an object has left the study.", false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_SPECIFY_GROUP_SIZE, "Allows you to specify the size of the sample group if not all members of the group are censored or have received an event.", false));
        type = new ParameterTypeInt(PARAMETER_GROUP_SIZE, "Size of the sample group", 1, Integer.MAX_VALUE, false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_SPECIFY_GROUP_SIZE, true, true));
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

