/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.descriptive.matrix;

import Jama.Matrix;
import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.operator.statistics.tools.NumericalMatrixGenerationRule;
import com.owc.tools.ExampleSetMatrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;
import org.apache.commons.math3.linear.RealMatrix;

public abstract class AbstractMatrixBasedOperator
extends LicensedOperator {
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private final OutputPort matrixOutput = (OutputPort)this.getOutputPorts().createPort("matrix");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private final AttributeSubsetSelector attributeSubsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInput, new int[]{2});

    public AbstractMatrixBasedOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition((Precondition)new ExampleSetPrecondition(this.exampleSetInput));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addRule((MDTransformationRule)new NumericalMatrixGenerationRule(this.getExampleSetInput(), this.matrixOutput));
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        ExampleSet originalSet = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        ExampleSet set = this.attributeSubsetSelector.getSubset(originalSet, false);
        if (!isLicensed && set.size() > 250) {
            throw new UserError((Operator)this, "statistics.license_exceeded_data_size", new Object[]{250});
        }
        for (Attribute attribute : set.getAttributes()) {
            if (attribute.isNumerical()) continue;
            throw new UserError((Operator)this, 144, new Object[]{attribute.getName(), this.getName()});
        }
        this.exampleSetOutput.deliver((IOObject)originalSet);
        this.matrixOutput.deliver((IOObject)this.computeMatrix(new ExampleSetMatrix(set), set));
    }

    protected abstract NumericalMatrix computeMatrix(RealMatrix var1, ExampleSet var2) throws UndefinedParameterError, UserError;

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSubsetSelector.getParameterTypes());
        return types;
    }

    protected InputPort getExampleSetInput() {
        return this.exampleSetInput;
    }

    protected OutputPort getMatrixOutput() {
        return this.matrixOutput;
    }

    protected static NumericalMatrix createNumericalMatrix(String name, ExampleSet exampleSet, double[][] data) {
        return new NumericalMatrix(name, AbstractMatrixBasedOperator.getColumnNames(exampleSet), new Matrix(data), false);
    }

    public static String[] getColumnNames(ExampleSet exampleSet) {
        String[] attributeNames = new String[exampleSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeNames[counter++] = attribute.getName();
        }
        return attributeNames;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

