/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.descriptive.matrix;

import com.owc.operator.statistics.descriptive.matrix.AbstractMatrixBasedOperator;
import com.owc.operator.statistics.tools.NumericalMatrixGenerationRule;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;

public class PearsonCorrelationMatrixOperator
extends AbstractMatrixBasedOperator {
    private final OutputPort pMatrixOutput = (OutputPort)this.getOutputPorts().createPort("p-value matrix");
    private final OutputPort errorMatrixOutput = (OutputPort)this.getOutputPorts().createPort("error matrix");

    public PearsonCorrelationMatrixOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new NumericalMatrixGenerationRule(this.getExampleSetInput(), this.pMatrixOutput));
        this.getTransformer().addRule((MDTransformationRule)new NumericalMatrixGenerationRule(this.getExampleSetInput(), this.errorMatrixOutput));
    }

    @Override
    protected NumericalMatrix computeMatrix(RealMatrix matrix, ExampleSet exampleSet) {
        PearsonsCorrelation correlation = new PearsonsCorrelation(matrix);
        if (this.pMatrixOutput.isConnected()) {
            this.pMatrixOutput.deliver((IOObject)PearsonCorrelationMatrixOperator.createNumericalMatrix("p-values", exampleSet, correlation.getCorrelationPValues().getData()));
        }
        if (this.errorMatrixOutput.isConnected()) {
            this.errorMatrixOutput.deliver((IOObject)PearsonCorrelationMatrixOperator.createNumericalMatrix("standard errors", exampleSet, correlation.getCorrelationStandardErrors().getData()));
        }
        RealMatrix correlationMatrix = correlation.getCorrelationMatrix();
        return PearsonCorrelationMatrixOperator.createNumericalMatrix("Pearson Correlation Matrix", exampleSet, correlationMatrix.getData());
    }
}

