/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.descriptive.ratio;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeParameterPrecondition;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RiskRatioOperator
extends LicensedOperator {
    private static final String ATTRIBUTE_ATTRIBUTE_NAME = "Attribute";
    private static final String ATTRIBUTE_RISK_RATIO = "RiskRatio";
    private static final String ATTRIBUTE_LOG_RISK_RATIO = "LogRiskRatio";
    private static final String ATTRIBUTE_STANDARD_ERROR = "StandardErrorRiskRatio";
    private static final String ATTRIBUTE_UPPER_CONFIDENCE_INTERVAL = "UpperConfidenceInterval";
    private static final String ATTRIBUTE_LOWER_CONFIDENCE_INTERVAL = "LowerConfidenceInterval";
    public static final String PARAMETER_TARGET_ATTRIBUTE = "target_attribute";
    public static final String PARAMETER_USE_WEIGHTS = "use_weights";
    public static final String PARAMETER_POSITIVE_VALUE = "positive_value";
    private final InputPort exampleSetInput = this.getInputPorts().createPort("example set input", ExampleSet.class);
    private final OutputPort ratioOutput = (OutputPort)this.getOutputPorts().createPort("ratio table output");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private AttributeSubsetSelector subsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInput, new int[]{6});
    private ExampleSetCreator exampleSetCreator = new ExampleSetCreator(new String[]{"Attribute", "RiskRatio", "LowerConfidenceInterval", "UpperConfidenceInterval", "LogRiskRatio", "StandardErrorRiskRatio"}, new int[]{7, 4, 4, 4, 4, 4});

    public RiskRatioOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInput, (Operator)this, PARAMETER_TARGET_ATTRIBUTE, 6));
        this.exampleSetInput.addPrecondition(this.subsetSelector.makePrecondition());
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.ratioOutput, this.exampleSetCreator.getMetaData()));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        ExampleSet set = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        if (!isLicensed && set.size() > 500) {
            throw new UserError((Operator)this, "statistics.license_exceeded_data_size", new Object[]{500});
        }
        String positiveValue = this.getParameterAsString(PARAMETER_POSITIVE_VALUE);
        String targetAttributeName = this.getParameterAsString(PARAMETER_TARGET_ATTRIBUTE);
        Attribute targetAttribute = set.getAttributes().get(targetAttributeName);
        Set groupBAttributesSet = this.subsetSelector.getAttributeSubset(set, false);
        groupBAttributesSet.remove(targetAttribute);
        boolean useWeights = this.getParameterAsBoolean(PARAMETER_USE_WEIGHTS);
        Attribute weightAttribute = set.getAttributes().getWeight();
        if (weightAttribute == null) {
            useWeights = false;
        }
        if (targetAttribute == null) {
            throw new UserError((Operator)this, 160, new Object[]{targetAttributeName});
        }
        if (targetAttribute.getValueType() != 6) {
            throw new UserError((Operator)this, "statistics.6", new Object[]{targetAttributeName, this.getName(), PARAMETER_TARGET_ATTRIBUTE});
        }
        if (targetAttribute.getMapping().getIndex(positiveValue) == -1) {
            throw new UserError((Operator)this, "statistics.7", new Object[]{targetAttributeName, this.getName(), PARAMETER_POSITIVE_VALUE});
        }
        for (Attribute groupBAttribute : groupBAttributesSet) {
            if (groupBAttribute.getValueType() != 6) {
                throw new UserError((Operator)this, "statistics.6", new Object[]{groupBAttribute.getName(), this.getName(), "Attribute Selector"});
            }
            if (groupBAttribute.getMapping().getIndex(positiveValue) != -1) continue;
            throw new UserError((Operator)this, "statistics.7", new Object[]{groupBAttribute.getName(), this.getName(), PARAMETER_POSITIVE_VALUE});
        }
        double targetPositiveValueIndex = targetAttribute.getMapping().getIndex(positiveValue);
        Attribute[] groupBAttributes = new Attribute[groupBAttributesSet.size()];
        double[] groupBAttributesPositiveValueIndex = new double[groupBAttributesSet.size()];
        int i = 0;
        Iterator iterator = groupBAttributesSet.iterator();
        while (iterator.hasNext()) {
            Attribute bAttribute;
            groupBAttributes[i] = bAttribute = (Attribute)iterator.next();
            groupBAttributesPositiveValueIndex[i] = bAttribute.getMapping().mapString(positiveValue);
            ++i;
        }
        double[] positiveCoocurrenceWeights = new double[groupBAttributesSet.size()];
        double[] negativeCoocurrenceWeights = new double[groupBAttributesSet.size()];
        double[] onlyTargetPositiveWeights = new double[groupBAttributesSet.size()];
        double[] onlyTargetNegativeWeights = new double[groupBAttributesSet.size()];
        for (Example example : set) {
            if (Double.isNaN(example.getValue(targetAttribute))) continue;
            double weight = 1.0;
            if (useWeights) {
                weight = example.getValue(weightAttribute);
            }
            boolean targetIsPositive = example.getValue(targetAttribute) == targetPositiveValueIndex;
            for (i = 0; i < groupBAttributesSet.size(); ++i) {
                boolean attributeIsPositive;
                if (Double.isNaN(example.getValue(groupBAttributes[i]))) continue;
                boolean bl = attributeIsPositive = example.getValue(groupBAttributes[i]) == groupBAttributesPositiveValueIndex[i];
                if (attributeIsPositive && targetIsPositive) {
                    int n = i;
                    positiveCoocurrenceWeights[n] = positiveCoocurrenceWeights[n] + weight;
                    continue;
                }
                if (!attributeIsPositive && !targetIsPositive) {
                    int n = i;
                    negativeCoocurrenceWeights[n] = negativeCoocurrenceWeights[n] + weight;
                    continue;
                }
                if (targetIsPositive && !attributeIsPositive) {
                    int n = i;
                    onlyTargetPositiveWeights[n] = onlyTargetPositiveWeights[n] + weight;
                    continue;
                }
                int n = i;
                onlyTargetNegativeWeights[n] = onlyTargetNegativeWeights[n] + weight;
            }
        }
        ExampleSetCreator exampleSetCreator = new ExampleSetCreator(new String[]{ATTRIBUTE_ATTRIBUTE_NAME, ATTRIBUTE_RISK_RATIO, ATTRIBUTE_LOWER_CONFIDENCE_INTERVAL, ATTRIBUTE_UPPER_CONFIDENCE_INTERVAL, ATTRIBUTE_LOG_RISK_RATIO, ATTRIBUTE_STANDARD_ERROR}, new int[]{7, 4, 4, 4, 4, 4});
        for (i = 0; i < groupBAttributesSet.size(); ++i) {
            exampleSetCreator.setValue(ATTRIBUTE_ATTRIBUTE_NAME, groupBAttributes[i].getName());
            double riskInfluencePositive = positiveCoocurrenceWeights[i] / (positiveCoocurrenceWeights[i] + onlyTargetNegativeWeights[i]);
            double riskInfluenceNegative = negativeCoocurrenceWeights[i] / (negativeCoocurrenceWeights[i] + onlyTargetPositiveWeights[i]);
            double riskRatio = riskInfluencePositive / riskInfluenceNegative;
            double standardErrorLogRatio = Math.sqrt(1.0 / positiveCoocurrenceWeights[i] + 1.0 / negativeCoocurrenceWeights[i] - 1.0 / (positiveCoocurrenceWeights[i] + onlyTargetNegativeWeights[i]) - 1.0 / (onlyTargetNegativeWeights[i] + negativeCoocurrenceWeights[i]));
            double logRiskRatio = Math.log(riskRatio);
            exampleSetCreator.setValue(ATTRIBUTE_RISK_RATIO, riskRatio);
            exampleSetCreator.setValue(ATTRIBUTE_LOG_RISK_RATIO, logRiskRatio);
            exampleSetCreator.setValue(ATTRIBUTE_STANDARD_ERROR, standardErrorLogRatio);
            exampleSetCreator.setValue(ATTRIBUTE_UPPER_CONFIDENCE_INTERVAL, Math.exp(logRiskRatio + 1.96 * standardErrorLogRatio));
            exampleSetCreator.setValue(ATTRIBUTE_LOWER_CONFIDENCE_INTERVAL, Math.exp(logRiskRatio - 1.96 * standardErrorLogRatio));
            exampleSetCreator.commit();
        }
        this.exampleSetOutput.deliver((IOObject)set);
        this.ratioOutput.deliver((IOObject)exampleSetCreator.finish());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_TARGET_ATTRIBUTE, "Select the target attribute of the analysis. The odds ratios of all selected attributes will be calculated against this attribute. Note that all attributes need to be binominal with the same values for the positive event.", this.exampleSetInput, false, new int[]{6});
        types.add((ParameterType)type);
        types.addAll(this.subsetSelector.getParameterTypes());
        types.add((ParameterType)new ParameterTypeString(PARAMETER_POSITIVE_VALUE, "This is the value identifying that this example is positive in regards of observed property.", false));
        type = new ParameterTypeBoolean(PARAMETER_USE_WEIGHTS, "Specifies whether rows should be counted with their weight or just having all an equal weight of 1.", false, false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

