/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.tests.mean;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.owc.tools.Frequency;
import com.owc.tools.ValueVector;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.stat.inference.OneWayAnova;

public class OneWayAnovaGroupingTestOperator
extends LicensedOperator {
    private static final String ATTRIBUTE_P_VALUE = "p_value";
    private static final String ATTRIBUTE_F_VALUE = "f_value";
    private static final String ATTRIBUTE_ATTRIBUTE = "attribute";
    private static final String ATTRIBUTE_NULL_HYPOTHESES_REJECTED = "null_hypothesis_rejected";
    public static final String PARAMETER_ALPHA = "confidence_level";
    private static final ExampleSetCreator RESULT_MD_CREATOR = new ExampleSetCreator(new String[]{"attribute", "f_value", "p_value", "null_hypothesis_rejected"}, new int[]{7, 4, 4, 6});
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private final OutputPort statisticsOutput = (OutputPort)this.getOutputPorts().createPort("statistics");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");
    private final AttributeSubsetSelector attributeSubsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInput);

    public OneWayAnovaGroupingTestOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.statisticsOutput, RESULT_MD_CREATOR.getMetaData()));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        ExampleSet set = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        if (!isLicensed && set.size() > 250) {
            throw new UserError((Operator)this, "statistics.license_exceeded_data_size", new Object[]{250});
        }
        double alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        ExampleSetCreator result = new ExampleSetCreator(new String[]{ATTRIBUTE_ATTRIBUTE, ATTRIBUTE_F_VALUE, ATTRIBUTE_P_VALUE, ATTRIBUTE_NULL_HYPOTHESES_REJECTED}, new int[]{7, 4, 4, 6});
        Set groupingAttributes = this.attributeSubsetSelector.getAttributeSubset(set, false);
        HashMap<ValueVector, Frequency> groupSizes = new HashMap<ValueVector, Frequency>();
        for (Example example : set) {
            ValueVector groupingValues = new ValueVector(groupingAttributes.size());
            int i = 0;
            for (Attribute groupAttribute : groupingAttributes) {
                groupingValues.values[i] = example.getValue(groupAttribute);
                ++i;
            }
            Frequency groupFrequency = (Frequency)groupSizes.get(groupingValues);
            if (groupFrequency == null) {
                groupFrequency = new Frequency();
                groupSizes.put(groupingValues, groupFrequency);
            }
            ++groupFrequency.frequency;
        }
        HashMap groupValues = new HashMap();
        for (Map.Entry entry : groupSizes.entrySet()) {
            groupValues.put(entry.getKey(), new ValueVector(((Frequency)entry.getValue()).frequency));
            ((Frequency)entry.getValue()).frequency = 0;
        }
        for (Attribute sample : set.getAttributes()) {
            if (!groupingAttributes.contains(sample)) {
                Object example2;
                for (Object example2 : set) {
                    ValueVector groupingValues = new ValueVector(groupingAttributes.size());
                    int i = 0;
                    for (Attribute groupAttribute : groupingAttributes) {
                        groupingValues.values[i] = example2.getValue(groupAttribute);
                        ++i;
                    }
                    double value = example2.getValue(sample);
                    Frequency groupSize = (Frequency)groupSizes.get(groupingValues);
                    ((ValueVector)groupValues.get((Object)groupingValues)).values[groupSize.frequency] = value;
                    ++groupSize.frequency;
                }
                LinkedList<double[]> groupValuesList = new LinkedList<double[]>();
                example2 = groupValues.entrySet().iterator();
                while (example2.hasNext()) {
                    Map.Entry entry = (Map.Entry)example2.next();
                    groupValuesList.add(((ValueVector)entry.getValue()).values);
                }
                OneWayAnova test = new OneWayAnova();
                double fValue = test.anovaFValue(groupValuesList);
                double pValue = test.anovaPValue(groupValuesList);
                boolean nullHypothesisRejected = pValue < alpha;
                result.setValue(ATTRIBUTE_ATTRIBUTE, sample.getName());
                result.setValue(ATTRIBUTE_P_VALUE, pValue);
                result.setValue(ATTRIBUTE_F_VALUE, fValue);
                result.setValue(ATTRIBUTE_NULL_HYPOTHESES_REJECTED, nullHypothesisRejected);
                result.commit();
            }
            for (Map.Entry entry : groupSizes.entrySet()) {
                ((Frequency)entry.getValue()).frequency = 0;
            }
        }
        this.exampleSetOutput.deliver((IOObject)set);
        this.statisticsOutput.deliver((IOObject)result.finish());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.attributeSubsetSelector.getParameterTypes());
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_ALPHA, "Performs a test evaluating the null hypothesis that the mean of the population from which example set is drawn equals the specified means. Returns true iff the null hypothesis can be rejected with confidence 1 - alpha.", 0.0, 0.5, 0.05, false));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

