/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.tests.mean;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.process.ports.metadata.PortConnectedPrecondition;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitStatisticsExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeParameterPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.PortProvider;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import java.util.List;
import org.apache.commons.math3.stat.inference.TTest;

public class TTestExpectationOperator
extends LicensedOperator {
    private static final String ATTRIBUTE_P_VALUE = "p_value";
    private static final String ATTRIBUTE_T_STATISTIC = "t_statistic";
    private static final String ATTRIBUTE_ATTRIBUTE = "attribute";
    private static final String ATTRIBUTE_EXPECTED_MEAN = "mean_expected";
    private static final String ATTRIBUTE_MEAN = "mean";
    private static final String ATTRIBUTE_NULL_HYPOTHESES_REJECTED = "null_hypothesis_rejected";
    public static final String PARAMETER_ATTRIBUTE_NAME_ATTRIBUTE = "attribute_name_attribute";
    public static final String PARAMETER_EXPECTED_MEAN = "expected_mean";
    private static final String PARAMETER_EXPECTED_MEANS = "expected_means";
    private static final String PARAMETER_ATTRIBUTE_NAME = "attribute";
    private static final String PARAMETER_MEAN_ATTRIBUTE = "mean_attribute";
    private static final String PARAMETER_ONE_SIDED_TEST = "one_sided_test";
    private static final String PARAMETER_ALPHA = "confidence_level";
    private static final ExampleSetCreator RESULT_MD_CREATOR = new ExampleSetCreator(new String[]{"attribute", "mean_expected", "mean", "t_statistic", "p_value", "null_hypothesis_rejected"}, new int[]{7, 4, 4, 4, 4, 6});
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private final InputPort referenceSetInput = (InputPort)this.getInputPorts().createPort("reference set input");
    private final OutputPort statisticsOutput = (OutputPort)this.getOutputPorts().createPort("statistics");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set output");

    public TTestExpectationOperator(OperatorDescription description) {
        super(description);
        this.referenceSetInput.addPrecondition((Precondition)new PortConnectedPrecondition(this.referenceSetInput, (Precondition)new AttributeParameterPrecondition(this.referenceSetInput, (Operator)this, PARAMETER_ATTRIBUTE_NAME_ATTRIBUTE), (Port)this.referenceSetInput, true));
        this.referenceSetInput.addPrecondition((Precondition)new PortConnectedPrecondition(this.referenceSetInput, (Precondition)new AttributeParameterPrecondition(this.referenceSetInput, (Operator)this, PARAMETER_MEAN_ATTRIBUTE), (Port)this.referenceSetInput, true));
        this.exampleSetInput.addPrecondition((Precondition)new ExampleSetPrecondition(this.exampleSetInput));
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.statisticsOutput, RESULT_MD_CREATOR.getMetaData()));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        double[] means;
        Attribute[] attributes;
        ExampleSet set = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        if (!isLicensed && set.size() > 150) {
            throw new UserError((Operator)this, "statistics.license_exceeded_data_size", new Object[]{150});
        }
        boolean oneSided = this.getParameterAsBoolean(PARAMETER_ONE_SIDED_TEST);
        double alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        if (oneSided) {
            alpha *= 2.0;
        }
        if (this.referenceSetInput.isConnected()) {
            ExampleSet referenceSet = (ExampleSet)this.referenceSetInput.getData(ExampleSet.class);
            Attribute attributeNameAttribute = referenceSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME_ATTRIBUTE));
            Attribute meanAttribute = referenceSet.getAttributes().get(this.getParameterAsString(PARAMETER_MEAN_ATTRIBUTE));
            if (attributeNameAttribute == null) {
                throw new UserError((Operator)this, 160, new Object[]{this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME_ATTRIBUTE)});
            }
            if (!attributeNameAttribute.isNominal()) {
                throw new UserError((Operator)this, "error.statistics.1", new Object[]{attributeNameAttribute.getName(), this.getName(), "attribute name attribute"});
            }
            if (meanAttribute == null) {
                throw new UserError((Operator)this, 160, new Object[]{this.getParameterAsString(PARAMETER_MEAN_ATTRIBUTE)});
            }
            if (!meanAttribute.isNumerical()) {
                throw new UserError((Operator)this, "error.statistics.2", new Object[]{meanAttribute.getName(), this.getName(), "mean attribute"});
            }
            attributes = new Attribute[referenceSet.size()];
            means = new double[referenceSet.size()];
            int i = 0;
            for (Example example : referenceSet) {
                double mean = example.getValue(meanAttribute);
                String attributeName = example.getNominalValue(attributeNameAttribute);
                Attribute attribute = set.getAttributes().get(attributeName);
                if (attribute == null) {
                    throw new UserError((Operator)this, 113, new Object[]{attributeName});
                }
                if (!attribute.isNumerical()) {
                    throw new UserError((Operator)this, 144, new Object[]{attributeName, this.getName()});
                }
                means[i] = mean;
                attributes[i] = attribute;
                ++i;
            }
        } else {
            List attributeMeans = this.getParameterList(PARAMETER_EXPECTED_MEANS);
            attributes = new Attribute[attributeMeans.size()];
            means = new double[attributeMeans.size()];
            int i = 0;
            for (String[] attributeMean : attributeMeans) {
                double mean = Double.parseDouble(attributeMean[1]);
                Attribute attribute = set.getAttributes().get(attributeMean[0]);
                if (attribute == null) {
                    throw new UserError((Operator)this, 160, new Object[]{attributeMean[0]});
                }
                if (!attribute.isNumerical()) {
                    throw new UserError((Operator)this, 144, new Object[]{attributeMean[0], this.getName()});
                }
                means[i] = mean;
                attributes[i] = attribute;
                ++i;
            }
        }
        ExampleSetCreator result = new ExampleSetCreator(new String[]{"attribute", ATTRIBUTE_EXPECTED_MEAN, ATTRIBUTE_MEAN, ATTRIBUTE_T_STATISTIC, ATTRIBUTE_P_VALUE, ATTRIBUTE_NULL_HYPOTHESES_REJECTED}, new int[]{7, 4, 4, 4, 4, 6});
        int attributeIndex = 0;
        for (Attribute attribute : attributes) {
            double sum = 0.0;
            double[] values = new double[set.size()];
            int i = 0;
            for (Example example : set) {
                values[i] = example.getValue(attribute);
                sum += values[i];
                ++i;
            }
            double mean = sum / (double)i;
            TTest test = new TTest();
            double t = test.t(means[attributeIndex], values);
            double pValue = test.tTest(means[attributeIndex], values);
            boolean nullHypothesisRejected = test.tTest(means[attributeIndex], values, alpha);
            if (oneSided) {
                pValue /= 2.0;
            }
            result.setValue(ATTRIBUTE_EXPECTED_MEAN, means[attributeIndex]);
            result.setValue(ATTRIBUTE_MEAN, mean);
            result.setValue("attribute", attribute.getName());
            result.setValue(ATTRIBUTE_P_VALUE, pValue);
            result.setValue(ATTRIBUTE_T_STATISTIC, t);
            result.setValue(ATTRIBUTE_NULL_HYPOTHESES_REJECTED, nullHypothesisRejected);
            result.commit();
            ++attributeIndex;
        }
        this.exampleSetOutput.deliver((IOObject)set);
        this.statisticsOutput.deliver((IOObject)result.finish());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        PortProvider portProvider = new PortProvider(){

            public Port getPort() {
                return TTestExpectationOperator.this.referenceSetInput;
            }
        };
        PortConnectedCondition isConnectedCondition = new PortConnectedCondition((ParameterHandler)this, portProvider, true, true);
        PortConnectedCondition isNotConnectedCondition = new PortConnectedCondition((ParameterHandler)this, portProvider, false, false);
        ParameterTypeList type = new ParameterTypeList(PARAMETER_EXPECTED_MEANS, "The values of the expected mean of the selected attributes.", (ParameterType)new ParameterTypeAttribute("attribute", "The attribute for which the mean should be used.", this.exampleSetInput, new int[]{2}), (ParameterType)new ParameterTypeDouble(PARAMETER_EXPECTED_MEAN, "The expected mean for the selected attribute.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true), false);
        type.registerDependencyCondition((ParameterCondition)isNotConnectedCondition);
        types.add((ParameterType)type);
        type = new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME_ATTRIBUTE, "Take the names of attributes that should be tested from this attribute of the reference set.", this.referenceSetInput, new int[]{1});
        type.setOptional(true);
        type.registerDependencyCondition((ParameterCondition)isConnectedCondition);
        types.add((ParameterType)type);
        type = new ParameterTypeAttribute(PARAMETER_MEAN_ATTRIBUTE, "Take the assumed means of attributes from this attribute of the reference set.", this.referenceSetInput, new int[]{2});
        type.setOptional(true);
        type.registerDependencyCondition((ParameterCondition)isConnectedCondition);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_ALPHA, "Performs a T-Test evaluating the null hypothesis that the mean of the population from which example set is drawn equals the specified means. Returns true iff the null hypothesis can be rejected with confidence 1 - alpha.", 0.0, 1.0, 0.05, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ONE_SIDED_TEST, "If checked, a one sided T-Test will be performed instead of a two sided one.", false, false));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitStatisticsExtension.PRODUCT_INFORMATION;
    }
}

