/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.tools;

import com.owc.process.ports.metadata.CollectedPassThroughMDRule;
import com.owc.tools.ValueVector;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.OneToManyPassThroughRule;
import com.rapidminer.operator.preprocessing.MaterializeDataInMemory;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SplitDataByGroupsOperator
extends Operator {
    public static final String PARAMETER_FIXED_GROUP_NUMBER = "exact_number_of_groups";
    public static final String PARAMETER_NUMBER_OF_GROUPS = "number_of_groups";
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set input");
    private OutputPortExtender groupDataExtender = new OutputPortExtender("grouped data", (Ports)this.getOutputPorts());
    private final OutputPort collectionOutput = (OutputPort)this.getOutputPorts().createPort("collection of grouped data");
    private final AttributeSubsetSelector attributeSubsetSelector = new AttributeSubsetSelector((ParameterHandler)this, this.exampleSetInput);

    public SplitDataByGroupsOperator(OperatorDescription description) {
        super(description);
        this.groupDataExtender.start();
        this.getTransformer().addRule((MDTransformationRule)new CollectedPassThroughMDRule(this.exampleSetInput, this.collectionOutput));
        this.getTransformer().addRule((MDTransformationRule)new OneToManyPassThroughRule(this.exampleSetInput, (Collection)this.groupDataExtender.getManagedPorts()));
    }

    public void doWork() throws OperatorException {
        ExampleSet set = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        boolean isRestrictingNumberOfGroups = this.getParameterAsBoolean(PARAMETER_FIXED_GROUP_NUMBER);
        int numberOfGroups = 0;
        if (isRestrictingNumberOfGroups) {
            numberOfGroups = this.getParameterAsInt(PARAMETER_NUMBER_OF_GROUPS);
        }
        Set groupingAttributes = this.attributeSubsetSelector.getAttributeSubset(set, false);
        int[] groupAssignment = new int[set.size()];
        HashMap<ValueVector, Integer> groupValueIndexMap = new HashMap<ValueVector, Integer>();
        int i = 0;
        for (Example example : set) {
            ValueVector groupingValues = new ValueVector(example, groupingAttributes);
            Integer groupIndex = (Integer)groupValueIndexMap.get(groupingValues);
            if (groupIndex == null) {
                groupIndex = groupValueIndexMap.size();
                groupValueIndexMap.put(groupingValues, groupIndex);
                if (isRestrictingNumberOfGroups && groupIndex >= numberOfGroups) {
                    throw new UserError((Operator)this, "statistics.4");
                }
            }
            groupAssignment[i] = groupIndex;
            ++i;
        }
        Partition partition = isRestrictingNumberOfGroups ? new Partition(groupAssignment, numberOfGroups) : new Partition(groupAssignment, groupValueIndexMap.size());
        SplittedExampleSet groupedSet = new SplittedExampleSet(set, partition);
        LinkedList<ExampleSet> sets = new LinkedList<ExampleSet>();
        for (i = 0; i < partition.getNumberOfSubsets(); ++i) {
            groupedSet.selectSingleSubset(i);
            sets.add(MaterializeDataInMemory.materializeExampleSet((ExampleSet)groupedSet, (int)0));
        }
        this.collectionOutput.deliver((IOObject)new IOObjectCollection(sets));
        this.groupDataExtender.deliver(sets);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(this.attributeSubsetSelector.getParameterTypes());
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_FIXED_GROUP_NUMBER, "If checked,  the operator will test, whether there is a specific number of groups and throw an error otherwise. This ensures that you can expect a specific number of ports or collection size.", false, false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_GROUPS, "This is the number of groups that will be found in the data. Each group will get one example set in the output.", 1, Integer.MAX_VALUE, true);
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_FIXED_GROUP_NUMBER, true, true));
        types.add(type);
        return types;
    }
}

