/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.statistics.tools;

import com.owc.license.LicenseManager;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;

public class StatisticsLicenseOperator
extends Operator {
    private OutputPort licensePort = (OutputPort)this.getOutputPorts().createPort("license output");
    public static final String ATTRIBUTE_EMAIL = "EMail";
    public static final String ATTRIBUTE_LICENSE_KEY = "LicenseKey";
    public static final String ATTRIBUTE_LICENSE_VALID = "Valid";
    public static final String ATTRIBUTE_LICENSE_MAINTAINED = "Maintained";
    private static ExampleSetCreator exampleSetCreator = new ExampleSetCreator(new String[]{"EMail", "LicenseKey", "Valid", "Maintained"}, new int[]{7, 7, 6, 6});

    public StatisticsLicenseOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.licensePort, exampleSetCreator.getMetaData()));
    }

    public void doWork() throws OperatorException {
        ExampleSetCreator creator = exampleSetCreator.getInstance();
        creator.setValue(ATTRIBUTE_EMAIL, LicenseManager.getEmailAddress("rmx_statistics"));
        creator.setValue(ATTRIBUTE_LICENSE_KEY, LicenseManager.getLicenseKey("rmx_statistics"));
        creator.setValue(ATTRIBUTE_LICENSE_VALID, LicenseManager.isLicenseValid("rmx_statistics"));
        creator.setValue(ATTRIBUTE_LICENSE_MAINTAINED, LicenseManager.isLicenseValidAndMaintained("rmx_statistics"));
        creator.commit();
        this.licensePort.deliver((IOObject)creator.finish());
    }
}

