/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.container.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExampleSetUnify {
    public static ExampleSet unifyExampleSets(List<ExampleSet> sets, Operator op) throws UserError {
        int i;
        HashMap<String, Pair> mappedAttributes = new HashMap<String, Pair>();
        LinkedList<String> attributeNamesList = new LinkedList<String>();
        LinkedList<Integer> attributeTypesList = new LinkedList<Integer>();
        LinkedList<Boolean> attributeIsNumeric = new LinkedList<Boolean>();
        boolean addAttribute = false;
        for (ExampleSet exampleSet : sets) {
            Attributes setAttributes = exampleSet.getAttributes();
            Iterator setAttributesIterator = setAttributes.allAttributes();
            while (setAttributesIterator.hasNext()) {
                Attribute attribute = (Attribute)setAttributesIterator.next();
                addAttribute = true;
                String selectedAttributeName = attribute.getName();
                if (mappedAttributes.containsKey(attribute.getName())) {
                    addAttribute = false;
                    int mappedType = ((Attribute)((Pair)mappedAttributes.get(attribute.getName())).getFirst()).getValueType();
                    if (mappedType != attribute.getValueType()) {
                        String suffix = "new";
                        selectedAttributeName = attribute.getName() + " " + suffix;
                        int suffixNumber = 1;
                        while (mappedAttributes.get(selectedAttributeName) != null) {
                            selectedAttributeName = attribute.getName() + " " + suffix + suffixNumber;
                            if (Integer.MAX_VALUE != ++suffixNumber) continue;
                            throw new UserError(op, "too many attributes with the same name detected.");
                        }
                        addAttribute = true;
                    }
                }
                if (!addAttribute) continue;
                Object selectedAttribute = attribute;
                AttributeRole role = setAttributes.getRole((Attribute)selectedAttribute);
                mappedAttributes.put(selectedAttributeName, new Pair(selectedAttribute, (Object)role));
                if (attribute.isNominal()) {
                    attributeTypesList.add(attribute.getValueType());
                    attributeNamesList.add(selectedAttributeName);
                    attributeIsNumeric.add(false);
                    continue;
                }
                if (!attribute.isNumerical() && !attribute.isDateTime()) continue;
                attributeTypesList.add(attribute.getValueType());
                attributeNamesList.add(selectedAttributeName);
                attributeIsNumeric.add(true);
            }
        }
        String[] attributeNames = attributeNamesList.toArray(new String[0]);
        int[] attributeTypes = new int[attributeTypesList.size()];
        for (i = 0; !attributeTypesList.isEmpty() && i < attributeTypes.length; ++i) {
            attributeTypes[i] = (Integer)attributeTypesList.poll();
        }
        ExampleSetCreator creator = new ExampleSetCreator(attributeNames, attributeTypes, false);
        for (ExampleSet exampleSet : sets) {
            for (Example example : exampleSet) {
                Iterator namesIterator = attributeNamesList.iterator();
                Iterator isNumericIterator = attributeIsNumeric.iterator();
                i = 0;
                while (namesIterator.hasNext()) {
                    String selectedAttributeName = (String)namesIterator.next();
                    boolean isNumeric = (Boolean)isNumericIterator.next();
                    Attribute selectedSetAttribute = exampleSet.getAttributes().get(((Attribute)((Pair)mappedAttributes.get(selectedAttributeName)).getFirst()).getName());
                    if (selectedSetAttribute != null && selectedSetAttribute.getValueType() == attributeTypes[i]) {
                        Double value;
                        if (!isNumeric) {
                            value = example.getValue(selectedSetAttribute);
                            if (!Double.isNaN(value)) {
                                creator.setValue(selectedAttributeName, example.getValueAsString(selectedSetAttribute));
                            }
                        } else {
                            value = example.getValue(selectedSetAttribute);
                            if (!Double.isNaN(value)) {
                                creator.setValue(selectedAttributeName, value);
                            }
                        }
                    }
                    ++i;
                }
                creator.commit();
            }
        }
        ExampleSet resultSet = creator.finish();
        Attributes resultAttributes = resultSet.getAttributes();
        for (Attribute selectedAttribute : resultAttributes) {
            AttributeRole selectedAttributeRole = (AttributeRole)((Pair)mappedAttributes.get(selectedAttribute.getName())).getSecond();
            if (selectedAttributeRole == null) continue;
            resultAttributes.getRole(selectedAttribute).setSpecial(selectedAttributeRole.getSpecialName());
        }
        return resultSet;
    }
}

