/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class RepositoryIterator
implements Iterator<Entry> {
    private LinkedList<Folder> folderStack = new LinkedList();
    private Iterator<DataEntry> entryIterator;

    public RepositoryIterator(RepositoryLocation repositoryLocation) throws RepositoryException {
        Entry startEntry = repositoryLocation.locateEntry();
        if (startEntry instanceof Folder) {
            Folder folder = (Folder)startEntry;
            this.folderStack.addAll(folder.getSubfolders());
            this.entryIterator = folder.getDataEntries().iterator();
        } else {
            this.entryIterator = Collections.singleton((DataEntry)startEntry).iterator();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.entryIterator != null && this.entryIterator.hasNext()) {
            return true;
        }
        while (!(this.folderStack.isEmpty() || this.entryIterator != null && this.entryIterator.hasNext())) {
            Folder nextFolder = this.folderStack.pollFirst();
            try {
                this.folderStack.addAll(nextFolder.getSubfolders());
                this.entryIterator = nextFolder.getDataEntries().iterator();
            }
            catch (RepositoryException repositoryException) {}
        }
        return this.entryIterator != null && this.entryIterator.hasNext();
    }

    @Override
    public Entry next() {
        if (this.hasNext()) {
            return (Entry)this.entryIterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
    }
}

