/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileUtils {
    public static String readTextFile(File file, String encoding) throws IOException {
        StringBuffer contents = new StringBuffer((int)file.length());
        String safeEncoding = encoding == null ? "" : encoding;
        BufferedReader bufferedReader = safeEncoding.length() > 0 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), safeEncoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        boolean eof = false;
        String contentLine = "";
        String eolChar = "\n";
        while (!eof) {
            contentLine = bufferedReader.readLine();
            if (contentLine == null) {
                eof = true;
                continue;
            }
            contents.append(contentLine);
            contents.append(eolChar);
        }
        bufferedReader.close();
        return contents.toString();
    }

    public static String readTextFile(File file) throws IOException {
        return FileUtils.readTextFile(file, null);
    }

    public static String readTextFile(String fileName, String encoding) throws IOException {
        return FileUtils.readTextFile(new File(fileName), encoding);
    }

    public static String readTextFile(String fileName) throws IOException {
        return FileUtils.readTextFile(new File(fileName));
    }

    public static void writeTextFile(File file, boolean append, String contents, String encoding) throws IOException {
        String safeEncoding = encoding == null ? "" : encoding;
        FileOutputStream outputStream = new FileOutputStream(file, append);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
        OutputStreamWriter writer = null;
        writer = safeEncoding.length() > 0 ? new OutputStreamWriter((OutputStream)bufferedStream, safeEncoding) : new OutputStreamWriter(bufferedStream);
        writer.write(contents);
        writer.flush();
        writer.close();
    }

    public static void writeTextFile(File file, boolean append, String contents) throws IOException {
        FileUtils.writeTextFile(file, append, contents, "");
    }

    public static void writeTextFile(String fileName, boolean append, String contents, String encoding) throws IOException {
        FileUtils.writeTextFile(new File(fileName), append, contents, encoding);
    }

    public static void writeTextFile(String fileName, boolean append, String contents) throws IOException {
        FileUtils.writeTextFile(new File(fileName), append, contents, "");
    }

    public static boolean copyFile(String srcFileName, String destFileName) {
        boolean result = false;
        byte[] buffer = new byte[128000];
        try {
            File srcFile = new File(srcFileName);
            if (!srcFile.exists()) {
                throw new IOException("File " + srcFileName + " not found.");
            }
            if (srcFile.isDirectory()) {
                throw new IOException("File " + srcFileName + " is a directory.");
            }
            long srcFileTime = srcFile.lastModified();
            if (!FileUtils.createPathForFile(destFileName)) {
                throw new IOException("Cannot create path for " + destFileName);
            }
            FileInputStream inputStream = new FileInputStream(srcFile);
            FileOutputStream outputStream = new FileOutputStream(destFileName);
            int nread = 0;
            do {
                if ((nread = ((InputStream)inputStream).read(buffer, 0, buffer.length)) <= 0) continue;
                ((OutputStream)outputStream).write(buffer, 0, nread);
            } while (nread >= 0);
            ((InputStream)inputStream).close();
            outputStream.flush();
            ((OutputStream)outputStream).close();
            File destFile = new File(destFileName);
            result = destFile.setLastModified(srcFileTime);
            result = result && destFile.lastModified() == srcFileTime;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean createPath(File directory) {
        boolean result = false;
        if (directory != null && !(result = directory.isDirectory())) {
            if (directory.exists()) {
                directory.delete();
            }
            result = directory.mkdirs();
        }
        return result;
    }

    public static boolean createPathForFile(String fileName) {
        boolean result = false;
        File file = new File(fileName);
        if (file != null) {
            result = FileUtils.createPath(new File(file.getAbsoluteFile().getParent()));
        }
        return result;
    }

    public static String getCurrentDirectory() {
        return System.getProperty("user.dir");
    }

    public static String chdir(String directory) {
        String currentDirectory = FileUtils.getCurrentDirectory();
        if (directory != null) {
            System.setProperty("user.dir", directory);
        }
        return currentDirectory;
    }

    protected FileUtils() {
    }
}

