/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.distributions;

import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.distributions.Beta;

public class FishersF {
    public static double f(double f, double dfn, double dfd) throws IllegalArgumentException {
        double result = 0.0;
        if (!(dfn > 0.0) || !(dfd > 0.0)) {
            throw new IllegalArgumentException("dfn or dfd <= 0");
        }
        result = Beta.incompleteBeta(dfd / (dfd + f * dfn), dfd / 2.0, dfn / 2.0, Constants.MAXPREC);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double fInverse(double p, double dfn, double dfd) throws IllegalArgumentException {
        double result = 0.0;
        if (!(dfn > 0.0)) throw new IllegalArgumentException("dfn or dfd <= 0");
        if (!(dfd > 0.0)) throw new IllegalArgumentException("dfn or dfd <= 0");
        if (!(p >= 0.0)) throw new IllegalArgumentException("p < 0 or p > 1");
        if (!(p <= 1.0)) throw new IllegalArgumentException("p < 0 or p > 1");
        result = Beta.incompleteBetaInverse(1.0 - p, dfn / 2.0, dfd / 2.0);
        if (!(result >= 0.0)) throw new ArithmeticException("inverse incomplete beta evaluation failed");
        if (!(result < 1.0)) throw new ArithmeticException("inverse incomplete beta evaluation failed");
        return result * dfd / (dfn * (1.0 - result));
    }

    protected FishersF() {
    }
}

