/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.distributions;

import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.Polynomial;
import edu.northwestern.at.utils.math.distributions.ErrorFunction;
import edu.northwestern.at.utils.math.distributions.Sig;

public class Normal {
    public static double normal(double z) {
        if (Double.isNaN(z)) {
            return z;
        }
        double result = z >= 0.0 ? (1.0 + ErrorFunction.errorFunction(z / Constants.SQRT2)) / 2.0 : ErrorFunction.errorFunctionComplement(-z / Constants.SQRT2) / 2.0;
        return result;
    }

    public static double normalInverse(double p) throws IllegalArgumentException {
        double z;
        double[] a = new double[]{3.3871328727963665, 133.14166789178438, 1971.5909503065513, 13731.69376550946, 45921.95393154987, 67265.7709270087, 33430.57558358813, 2509.0809287301227};
        double[] b = new double[]{1.0, 42.31333070160091, 687.1870074920579, 5394.196021424751, 21213.794301586597, 39307.89580009271, 28729.085735721943, 5226.495278852854};
        double[] c = new double[]{1.4234371107496835, 4.630337846156546, 5.769497221460691, 3.6478483247632045, 1.2704582524523684, 0.2417807251774506, 0.022723844989269184, 7.745450142783414E-4};
        double[] d = new double[]{1.0, 2.053191626637759, 1.6763848301838038, 0.6897673349851, 0.14810397642748008, 0.015198666563616457, 5.475938084995345E-4, 1.0507500716444169E-9};
        double[] e = new double[]{6.657904643501103, 5.463784911164114, 1.7848265399172913, 0.29656057182850487, 0.026532189526576124, 0.0012426609473880784, 2.7115555687434876E-5, 2.0103343992922881E-7};
        double[] f = new double[]{1.0, 0.599832206555888, 0.1369298809227358, 0.014875361290850615, 7.868691311456133E-4, 1.8463183175100548E-5, 1.421511758316446E-7, 2.0442631033899397E-15};
        double SPLIT1 = 0.425;
        double CONST1 = 0.180625;
        double SPLIT2 = 5.0;
        double CONST2 = 1.6;
        if (p > 1.0) {
            throw new IllegalArgumentException("p>1");
        }
        if (p < 0.0) {
            throw new IllegalArgumentException("p<0");
        }
        if (p == 1.0) {
            z = Double.POSITIVE_INFINITY;
        } else if (p == 0.0) {
            z = Double.NEGATIVE_INFINITY;
        } else {
            double r;
            double q = p - 0.5;
            if (Math.abs(q) <= 0.425) {
                r = 0.180625 - q * q;
                z = q * Polynomial.hornersMethod(a, r) / Polynomial.hornersMethod(b, r);
            } else {
                r = q < 0.0 ? p : 1.0 - p;
                r = Math.sqrt(-Math.log(r));
                z = r <= 5.0 ? Polynomial.hornersMethod(c, r -= 1.6) / Polynomial.hornersMethod(d, r) : Polynomial.hornersMethod(e, r -= 5.0) / Polynomial.hornersMethod(f, r);
                if (q < 0.0) {
                    z = -z;
                }
            }
            for (int i = 0; i < 2; ++i) {
                double p1 = Sig.normal(z);
                double phi = Math.sqrt(0.15915494309189535) * Math.exp(-(z * z) / 2.0);
                double z2 = (p - p1) / phi;
                double x3 = (2.0 * (z * z) + 1.0) * z2 / 3.0;
                double x2 = (x3 + z) * z2 / 2.0;
                double x1 = (x2 + 1.0) * z2;
                z += x1;
            }
        }
        return z;
    }

    public static double normalInverseBad(double p) {
        double result = Constants.SQRT2 * ErrorFunction.errorFunctionInverseBad(2.0 * p - 1.0);
        return result;
    }

    protected Normal() {
    }
}

