/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixFactory;
import edu.northwestern.at.utils.math.matrix.MatrixMismatchedSizeException;
import edu.northwestern.at.utils.math.matrix.MatrixToString;

public abstract class AbstractMatrix
implements Matrix {
    protected int rows;
    protected int columns;

    protected AbstractMatrix() {
    }

    public AbstractMatrix(int rows, int columns) {
        if (rows < 1 || columns < 1) {
            throw new IllegalArgumentException("Matrix must have positive number of rows and columns");
        }
        this.rows = rows;
        this.columns = columns;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int columns() {
        return this.columns;
    }

    @Override
    public abstract void set(int var1, int var2, double var3);

    @Override
    public void set(Matrix matrix) throws MatrixMismatchedSizeException {
        if (matrix != null) {
            if (this.rows() != matrix.rows() || this.columns() != matrix.columns()) {
                throw new MatrixMismatchedSizeException("Source matrix not same size");
            }
            for (int j = 1; j <= this.columns(); ++j) {
                for (int i = 1; i <= this.rows(); ++i) {
                    this.set(i, j, matrix.get(i, j));
                }
            }
        }
    }

    @Override
    public Matrix getCopy() {
        Matrix result = MatrixFactory.createMatrix(this.rows(), this.columns(), this.getClass());
        for (int i = 1; i <= this.rows(); ++i) {
            for (int j = 1; j <= this.columns(); ++j) {
                result.set(i, j, this.get(i, j));
            }
        }
        return result;
    }

    @Override
    public void set(double[][] values) {
        if (values != null) {
            for (int j = 1; j <= this.columns(); ++j) {
                for (int i = 1; i <= this.rows(); ++i) {
                    try {
                        this.set(i, j, values[i - 1][j - 1]);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.set(i, j, 0.0);
                    }
                }
            }
        }
    }

    @Override
    public abstract double get(int var1, int var2);

    @Override
    public Matrix getRow(int row) {
        Matrix result = MatrixFactory.createMatrix(1, this.columns(), this.getClass());
        for (int j = 1; j <= this.columns(); ++j) {
            result.set(1, j, this.get(row, j));
        }
        return result;
    }

    @Override
    public double[] getRowData(int row) {
        double[] result = new double[this.columns()];
        for (int j = 1; j <= this.columns(); ++j) {
            result[j - 1] = this.get(row, j);
        }
        return result;
    }

    @Override
    public void setRow(int row, Matrix rowMatrix) {
        if (row > 0 && row <= this.rows() && rowMatrix != null) {
            int i;
            for (i = 1; i <= rowMatrix.columns(); ++i) {
                if (i > this.columns()) continue;
                this.set(row, i, rowMatrix.get(1, i));
            }
            for (i = rowMatrix.columns() + 1; i <= this.columns(); ++i) {
                this.set(row, i, 0.0);
            }
        }
    }

    @Override
    public void setRowData(int row, double[] rowData) {
        if (row > 0 && row <= this.rows() && rowData != null) {
            int i;
            for (i = 0; i < rowData.length; ++i) {
                if (i >= this.columns()) continue;
                this.set(row, i + 1, rowData[i]);
            }
            for (i = rowData.length + 1; i <= this.columns(); ++i) {
                this.set(row, i, 0.0);
            }
        }
    }

    @Override
    public Matrix getColumn(int column) {
        Matrix result = MatrixFactory.createMatrix(this.rows(), 1, this.getClass());
        for (int i = 1; i <= this.rows(); ++i) {
            result.set(i, 1, this.get(i, column));
        }
        return result;
    }

    @Override
    public double[] getColumnData(int column) {
        double[] result = new double[this.rows()];
        for (int i = 1; i <= this.rows(); ++i) {
            result[i - 1] = this.get(i, column);
        }
        return result;
    }

    @Override
    public void setColumn(int column, Matrix columnMatrix) {
        if (column > 0 && column <= this.columns() && columnMatrix != null) {
            int i;
            for (i = 1; i <= columnMatrix.rows(); ++i) {
                if (i > this.rows()) continue;
                this.set(i, column, columnMatrix.get(i, 1));
            }
            for (i = columnMatrix.rows() + 1; i <= this.rows(); ++i) {
                this.set(i, column, 0.0);
            }
        }
    }

    @Override
    public void setColumnData(int column, double[] columnData) {
        if (column > 0 && column <= this.columns() && columnData != null) {
            int i;
            for (i = 0; i < columnData.length; ++i) {
                if (i >= this.rows()) continue;
                this.set(i + 1, column, columnData[i]);
            }
            for (i = columnData.length + 1; i <= this.rows(); ++i) {
                this.set(i, column, 0.0);
            }
        }
    }

    @Override
    public void setColumnData(int column, int[] columnData) {
        if (column > 0 && column <= this.columns() && columnData != null) {
            int i;
            for (i = 0; i < columnData.length; ++i) {
                if (i >= this.rows()) continue;
                this.set(i + 1, column, columnData[i]);
            }
            for (i = columnData.length + 1; i <= this.rows(); ++i) {
                this.set(i, column, 0.0);
            }
        }
    }

    @Override
    public double[][] get() {
        double[][] result = new double[this.rows()][this.columns()];
        for (int j = 1; j <= this.columns(); ++j) {
            for (int i = 1; i <= this.rows(); ++i) {
                result[i - 1][j - 1] = this.get(i, j);
            }
        }
        return result;
    }

    @Override
    public Matrix getSubMatrix(int firstRow, int firstColumn, int lastRow, int lastColumn) {
        Matrix result = MatrixFactory.createMatrix(lastRow - firstRow + 1, lastColumn - firstColumn + 1, this.getClass());
        if (result.rows() > this.rows() || result.columns() > this.columns()) {
            result = null;
            throw new MatrixMismatchedSizeException("Submatrix violates dimension constraints");
        }
        for (int row = firstRow; row <= lastRow; ++row) {
            for (int col = firstColumn; col <= lastColumn; ++col) {
                result.set(row - firstRow + 1, col - firstColumn + 1, this.get(row, col));
            }
        }
        return result;
    }

    @Override
    public Matrix getSubMatrix(int[] rows, int[] columns) {
        Matrix result = MatrixFactory.createMatrix(rows.length, columns.length, this.getClass());
        for (int row = 1; row <= rows.length; ++row) {
            for (int col = 1; col <= columns.length; ++col) {
                result.set(row, col, this.get(rows[row - 1], columns[col - 1]));
            }
        }
        return result;
    }

    @Override
    public Matrix getSubMatrix(int firstRow, int lastRow, int[] columns) {
        Matrix result = MatrixFactory.createMatrix(lastRow - firstRow + 1, columns.length, this.getClass());
        if (result.rows() > this.rows()) {
            result = null;
            throw new MatrixMismatchedSizeException("Submatrix violates dimension constraints");
        }
        for (int row = firstRow; row <= lastRow; ++row) {
            for (int col = 1; col <= columns.length; ++col) {
                result.set(row - firstRow + 1, col, this.get(row, columns[col - 1]));
            }
        }
        return result;
    }

    @Override
    public Matrix getSubMatrix(int[] rows, int firstColumn, int lastColumn) {
        Matrix result = MatrixFactory.createMatrix(rows.length, lastColumn - firstColumn + 1, this.getClass());
        if (result.columns() > this.columns()) {
            result = null;
            throw new MatrixMismatchedSizeException("Submatrix violates dimension constraints");
        }
        for (int row = 1; row <= rows.length; ++row) {
            for (int col = firstColumn; col <= lastColumn; ++col) {
                result.set(row, col - firstColumn + 1, this.get(rows[row - 1], col));
            }
        }
        return result;
    }

    @Override
    public Matrix getColumns(int firstColumn, int lastColumn) {
        return this.getSubMatrix(1, firstColumn, this.rows(), lastColumn);
    }

    @Override
    public Matrix getColumns(int[] columns) {
        return this.getSubMatrix(1, this.rows(), columns);
    }

    @Override
    public Matrix getRows(int firstRow, int lastRow) {
        return this.getSubMatrix(firstRow, 1, lastRow, this.columns());
    }

    @Override
    public Matrix getRows(int[] rows) {
        return this.getSubMatrix(rows, 1, this.columns());
    }

    @Override
    public String toString() {
        return MatrixToString.toString(this);
    }
}

