/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixFactory;

public class LUDecomposition {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix a) {
        this.LU = a.get();
        this.m = a.rows();
        this.n = a.columns();
        this.piv = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.piv[i] = i + 1;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.m];
        for (int j = 0; j < this.n; ++j) {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m; ++i2) {
                LUcolj[i2] = this.LU[i2][j];
            }
            i2 = 0;
            while (i2 < this.m) {
                double[] LUrowi = this.LU[i2];
                int kmax = Math.min(i2, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * LUcolj[k];
                }
                int n = i2++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            for (i = j + 1; i < this.m; ++i) {
                if (!(Math.abs(LUcolj[i]) > Math.abs(LUcolj[p]))) continue;
                p = i;
            }
            if (p != j) {
                int k;
                for (k = 0; k < this.n; ++k) {
                    double t = this.LU[p][k];
                    this.LU[p][k] = this.LU[j][k];
                    this.LU[j][k] = t;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (j >= this.m || this.LU[j][j] == 0.0) continue;
            for (i = j + 1; i < this.m; ++i) {
                double[] dArray = this.LU[i];
                int n = j;
                dArray[n] = dArray[n] / this.LU[j][j];
            }
        }
    }

    public boolean isNonsingular() {
        for (int j = 0; j < this.n; ++j) {
            if (this.LU[j][j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public boolean isSingular() {
        return !this.isNonsingular();
    }

    public Matrix getL() {
        double[][] L = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                L[i][j] = i > j ? this.LU[i][j] : (i == j ? 1.0 : 0.0);
            }
        }
        return MatrixFactory.createMatrix(this.m, this.n, L);
    }

    public Matrix getU() {
        double[][] U = new double[this.m][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                U[i][j] = i <= j ? this.LU[i][j] : 0.0;
            }
        }
        return MatrixFactory.createMatrix(this.m, this.n, U);
    }

    public int[] getPivot() {
        return (int[])this.piv.clone();
    }

    public double[][] getDoublePivot() {
        double[][] vals = new double[this.m][1];
        for (int i = 0; i < this.m; ++i) {
            vals[i][0] = this.piv[i];
        }
        return vals;
    }

    public Matrix getPivotMatrix() {
        double[][] dblPivot = this.getDoublePivot();
        return MatrixFactory.createMatrix(dblPivot.length, 1, dblPivot);
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int j = 0; j < this.n; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }

    public Matrix solve(Matrix B) {
        int j;
        int i;
        int k;
        if (B.rows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.columns();
        Matrix Xmat = B.getSubMatrix(this.piv, 1, nx);
        double[][] X = Xmat.get();
        for (k = 0; k < this.n; ++k) {
            for (i = k + 1; i < this.n; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            int j2 = 0;
            while (j2 < nx) {
                double[] dArray = X[k];
                int n = j2++;
                dArray[n] = dArray[n] / this.LU[k][k];
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                }
            }
        }
        return MatrixFactory.createMatrix(Xmat.rows(), Xmat.columns(), X);
    }
}

