/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.math.ArithUtils;
import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixMeasure;
import edu.northwestern.at.utils.math.matrix.MatrixMismatchedSizeException;
import edu.northwestern.at.utils.math.matrix.MatrixOperator;

public class MatricesMeasure {
    public static double dotProduct(Matrix a, Matrix b) {
        if (MatricesMeasure.areSameSize(a, b)) {
            return MatrixMeasure.sum(MatrixOperator.multiplyEBE(a, b));
        }
        throw new MatrixMismatchedSizeException("Matrices must have same size to compute dot product.");
    }

    public static boolean areEqual(Matrix a, Matrix b, double tolerance) {
        boolean result = false;
        if (MatricesMeasure.areSameSize(a, b)) {
            for (int row = 1; row <= a.rows(); ++row) {
                for (int col = 1; col <= a.columns(); ++col) {
                    if (ArithUtils.areEqual(a.get(row, col), b.get(row, col), tolerance)) continue;
                    return false;
                }
            }
            result = true;
        }
        return result;
    }

    public static boolean areEqual(Matrix a, Matrix b) {
        return MatricesMeasure.areEqual(a, b, Constants.MACHEPS);
    }

    public static boolean areSameSize(Matrix a, Matrix b) {
        return a.rows() == b.rows() && a.columns() == b.columns();
    }
}

