/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixFactory;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MatrixFromString {
    public static final MatrixFromStringParser matlabMatrixFromString = new MatrixFromStringParser("\\[", "\\]", "", ";", "", ",");
    public static final MatrixFromStringParser gaussMatrixFromString = new MatrixFromStringParser("\\{", "\\}", "", ",", "", "\\s");
    public static final MatrixFromStringParser plainTextMatrixFromString = new MatrixFromStringParser("", "", "", "\\n", "", "\\s");
    public static final MatrixFromStringParser mathMLMatrixFromString = new MatrixFromStringParser("<matrix>", "</matrix>", "<matrixrow>", "</matrixrow>", "<cn>", "</cn>");

    public static Matrix parseMatrix(String src, MatrixFromStringParser parser) {
        return parser.parse(src);
    }

    public static Matrix fromMatlabString(String src) {
        return MatrixFromString.parseMatrix(src, matlabMatrixFromString);
    }

    public static Matrix fromGaussString(String src) {
        return MatrixFromString.parseMatrix(src, gaussMatrixFromString);
    }

    public static Matrix fromPlainTextString(String src) {
        return MatrixFromString.parseMatrix(src, plainTextMatrixFromString);
    }

    public static Matrix fromMathMLString(String src) {
        return MatrixFromString.parseMatrix(src, mathMLMatrixFromString);
    }

    protected MatrixFromString() {
    }

    public static class MatrixFromStringParser {
        protected String startMatrixString;
        protected String endMatrixString;
        protected String startRowString;
        protected String endRowString;
        protected String startEntryString;
        protected String endEntryString;
        protected boolean skipLF;

        public MatrixFromStringParser(String startMatrixString, String endMatrixString, String startRowString, String endRowString, String startEntryString, String endEntryString) {
            this.startMatrixString = startMatrixString;
            this.endMatrixString = endMatrixString;
            this.startRowString = startRowString;
            this.endRowString = endRowString;
            this.startEntryString = startEntryString;
            this.endEntryString = endEntryString;
            this.skipLF = startRowString.indexOf(10) == 0 && endRowString.indexOf(10) == 0;
        }

        protected Matrix parse(String matrixDefinition) {
            matrixDefinition = MatrixFromStringParser.deleteRedundantWhitespace(matrixDefinition, this.skipLF);
            double[][] values = this.processRows(this.divideIntoRows(this.discardStartEnd(matrixDefinition, this.startMatrixString, this.endMatrixString)));
            return MatrixFactory.createMatrix(values.length, values[0].length, values);
        }

        protected String discardStartEnd(String sourceString, String startString, String endString) {
            if (startString.length() > 0) {
                try {
                    sourceString = sourceString.split(startString)[1];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (endString.length() > 0) {
                try {
                    sourceString = sourceString.split(endString)[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return sourceString;
        }

        protected String[] divideIntoRows(String sourceString) {
            int irow;
            String[] rows = null;
            if (this.startRowString.length() > 0) {
                rows = sourceString.split(this.startRowString);
            } else if (this.endRowString.length() > 0) {
                rows = sourceString.split(this.endRowString);
            }
            ArrayList<String> newRows = new ArrayList<String>(rows.length);
            for (irow = 0; irow < rows.length; ++irow) {
                rows[irow] = this.discardStartEnd(rows[irow], this.startRowString, this.endRowString);
                rows[irow] = MatrixFromStringParser.deleteRedundantWhitespace(rows[irow], false).trim();
                if (rows[irow].length() <= 0) continue;
                newRows.add(new String(rows[irow]));
            }
            rows = new String[newRows.size()];
            for (irow = 0; irow < newRows.size(); ++irow) {
                rows[irow] = (String)newRows.get(irow);
            }
            return rows;
        }

        protected double[][] processRows(String[] rows) {
            Object values = new double[rows.length][];
            for (int row = 0; row < rows.length; ++row) {
                values = this.parseIndividualEntries(MatrixFromStringParser.deleteRedundantWhitespace(rows[row], false), row, (double[][])values);
            }
            return values;
        }

        protected double[][] parseIndividualEntries(String rowString, int row, double[][] values) {
            int i;
            String[] stringEntries = null;
            String localRowStr = rowString.trim();
            if (this.startEntryString.length() > 0) {
                stringEntries = localRowStr.split(this.startEntryString);
            } else if (this.endEntryString.length() > 0) {
                stringEntries = localRowStr.split(this.endEntryString);
            }
            ArrayList<String> newEntries = new ArrayList<String>(stringEntries.length);
            for (i = 0; i < stringEntries.length; ++i) {
                stringEntries[i] = this.discardStartEnd(stringEntries[i], this.startEntryString, this.endEntryString);
                stringEntries[i] = MatrixFromStringParser.deleteRedundantWhitespace(stringEntries[i], false).trim();
                if (stringEntries[i].length() <= 0) continue;
                newEntries.add(new String(stringEntries[i]));
            }
            stringEntries = new String[newEntries.size()];
            for (i = 0; i < newEntries.size(); ++i) {
                stringEntries[i] = (String)newEntries.get(i);
            }
            values[row] = new double[stringEntries.length];
            for (int element = 0; element < stringEntries.length; ++element) {
                values[row][element] = Double.parseDouble(stringEntries[element]);
            }
            return values;
        }

        protected static String deleteRedundantWhitespace(String inputString, boolean skipLF) {
            String patternStr = "\\s+";
            if (!skipLF) {
                patternStr = "[ \\t\\x0B\\f\\r]";
            }
            String replaceStr = " ";
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(inputString);
            return matcher.replaceAll(replaceStr);
        }
    }
}

