/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.matrix;

import edu.northwestern.at.utils.math.ArithUtils;
import edu.northwestern.at.utils.math.matrix.CholeskyDecomposition;
import edu.northwestern.at.utils.math.matrix.EigenvalueDecomposition;
import edu.northwestern.at.utils.math.matrix.LUDecomposition;
import edu.northwestern.at.utils.math.matrix.MatricesMeasure;
import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixFactory;
import edu.northwestern.at.utils.math.matrix.MatrixTransformer;

public class MatrixProperty {
    public static int[] bandwidth(Matrix matrix, double tolerance) {
        int lowerBandWidth = 0;
        int upperBandWidth = 0;
        int diagNotZero = 0;
        int rows = matrix.rows();
        int columns = matrix.columns();
        int minDimension = Math.min(rows, columns);
        for (int i = 1; i <= rows; ++i) {
            int j;
            for (j = i + 1; j <= columns; ++j) {
                if (ArithUtils.areEqual(matrix.get(i, j), 0.0, tolerance)) continue;
                upperBandWidth = Math.max(Math.abs(i - j), upperBandWidth);
            }
            if (i <= minDimension && !ArithUtils.areEqual(matrix.get(i, i), 0.0, tolerance)) {
                ++diagNotZero;
            }
            for (j = 1; j < i; ++j) {
                if (ArithUtils.areEqual(matrix.get(i, j), 0.0, tolerance)) continue;
                lowerBandWidth = Math.max(Math.abs(i - j), lowerBandWidth);
            }
        }
        int bandWidth = lowerBandWidth + upperBandWidth + (diagNotZero > 0 ? 1 : 0);
        int[] result = new int[]{lowerBandWidth, upperBandWidth, bandWidth};
        return result;
    }

    public static int[] bandwidth(Matrix matrix) {
        return MatrixProperty.bandwidth(matrix, 0.0);
    }

    public static boolean isColumnVector(Matrix matrix) {
        return matrix.columns() == 1;
    }

    public static boolean isDiagonal(Matrix matrix, double tolerance) {
        if (MatrixProperty.isSquare(matrix)) {
            for (int row = 1; row <= matrix.rows(); ++row) {
                for (int col = 1; col <= matrix.columns(); ++col) {
                    if (row == col || ArithUtils.areEqual(matrix.get(row, col), 0.0, tolerance)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isDiagonal(Matrix matrix) {
        return MatrixProperty.isDiagonal(matrix, 0.0);
    }

    public static boolean isHigh(Matrix matrix) {
        return matrix.rows() > matrix.columns();
    }

    public static boolean isIdempotent(Matrix matrix, double tolerance) {
        return MatricesMeasure.areEqual(matrix, MatrixTransformer.pow(matrix, 2), tolerance);
    }

    public static boolean isIdempotent(Matrix matrix) {
        return MatricesMeasure.areEqual(matrix, MatrixTransformer.pow(matrix, 2), 0.0);
    }

    public static boolean isIdentity(Matrix matrix, double tolerance) {
        return MatrixProperty.isSquare(matrix) && MatricesMeasure.areEqual(matrix, MatrixFactory.createIdentityMatrix(matrix.rows()), tolerance);
    }

    public static boolean isIdentity(Matrix matrix) {
        return MatrixProperty.isSquare(matrix) && MatricesMeasure.areEqual(matrix, MatrixFactory.createIdentityMatrix(matrix.rows()));
    }

    public static boolean isLowerTriangular(Matrix matrix, double tolerance) {
        return MatricesMeasure.areEqual(MatrixTransformer.extractLowerTriangle(matrix, 0), matrix, tolerance);
    }

    public static boolean isLowerTriangular(Matrix matrix) {
        return MatricesMeasure.areEqual(MatrixTransformer.extractLowerTriangle(matrix, 0), matrix);
    }

    public static boolean isPositiveDefinite(Matrix matrix) {
        boolean result = true;
        if (MatrixProperty.isSquare(matrix)) {
            EigenvalueDecomposition eigDecomp = new EigenvalueDecomposition(matrix);
            double[] realEigenValues = eigDecomp.getRealEigenvalues();
            double[] imaginaryEigenValues = eigDecomp.getImagEigenvalues();
            for (int i = 0; i < realEigenValues.length; ++i) {
                result = result && realEigenValues[i] > 0.0 && imaginaryEigenValues[i] == 0.0;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isRowVector(Matrix matrix) {
        return matrix.rows() == 1;
    }

    public static boolean isScalar(Matrix matrix, double tolerance) {
        double diagValue = matrix.get(1, 1);
        if (MatrixProperty.isSquare(matrix)) {
            for (int row = 1; row <= matrix.rows(); ++row) {
                for (int column = 1; column <= matrix.columns(); ++column) {
                    if (!(row == column ? !ArithUtils.areEqual(diagValue, matrix.get(row, column), tolerance) : matrix.get(row, column) != 0.0)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isSemiPositiveDefinite(Matrix matrix) {
        boolean result = true;
        if (MatrixProperty.isSquare(matrix)) {
            EigenvalueDecomposition eigDecomp = new EigenvalueDecomposition(matrix);
            double[] realEigenValues = eigDecomp.getRealEigenvalues();
            double[] imaginaryEigenValues = eigDecomp.getImagEigenvalues();
            for (int i = 0; i < realEigenValues.length; ++i) {
                result = result && realEigenValues[i] >= 0.0 && imaginaryEigenValues[i] == 0.0;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isSingular(Matrix matrix) {
        return new LUDecomposition(matrix).isSingular();
    }

    public static boolean isSkewSymmetric(Matrix matrix, double tolerance) {
        return MatricesMeasure.areEqual(MatrixTransformer.transpose(matrix), MatrixTransformer.negate(matrix), tolerance);
    }

    public static boolean isSkewSymmetric(Matrix matrix) {
        return MatricesMeasure.areEqual(MatrixTransformer.transpose(matrix), MatrixTransformer.negate(matrix));
    }

    public static boolean isSquare(Matrix matrix) {
        return matrix.rows() == matrix.columns();
    }

    public static boolean isSymmetric(Matrix matrix, double tolerance) {
        return MatricesMeasure.areEqual(matrix, MatrixTransformer.transpose(matrix), tolerance);
    }

    public static boolean isSymmetric(Matrix matrix) {
        return MatricesMeasure.areEqual(matrix, MatrixTransformer.transpose(matrix));
    }

    public static boolean isSymmetricPositiveDefinite(Matrix matrix) {
        return new CholeskyDecomposition(matrix).isSPD();
    }

    public static boolean isUnit(Matrix matrix, double tolerance) {
        return MatrixProperty.isIdentity(matrix, tolerance);
    }

    public static boolean isUnit(Matrix matrix) {
        return MatrixProperty.isIdentity(matrix);
    }

    public static boolean isUpperTriangular(Matrix matrix) {
        return MatricesMeasure.areEqual(MatrixTransformer.extractUpperTriangle(matrix, 0), matrix);
    }

    public static boolean isVector(Matrix matrix) {
        return matrix.columns() == 1 || matrix.rows() == 1;
    }

    public static boolean isWide(Matrix matrix) {
        return matrix.rows() < matrix.columns();
    }

    protected MatrixProperty() {
    }
}

