/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.rootfinders;

import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.MonadicFunction;
import edu.northwestern.at.utils.math.rootfinders.BracketRoot;
import edu.northwestern.at.utils.math.rootfinders.MonadicFunctionRootFinder;
import edu.northwestern.at.utils.math.rootfinders.RootFinderConvergenceTest;
import edu.northwestern.at.utils.math.rootfinders.RootFinderIterationInformation;
import edu.northwestern.at.utils.math.rootfinders.StandardRootFinderConvergenceTest;

public class Brent
implements MonadicFunctionRootFinder {
    public static double brent(double x0, double x1, double tol, int maxIter, MonadicFunction function, RootFinderConvergenceTest convergenceTest, RootFinderIterationInformation iterationInformation) throws IllegalArgumentException {
        double EPS = Constants.MACHEPS / 2.0;
        double a = x0;
        double b = x1;
        double c = x1;
        double d = 0.0;
        double e = 0.0;
        double fa = function.f(a);
        double fb = function.f(b);
        if (fa > 0.0 && fb > 0.0 || fa < 0.0 && fb < 0.0) {
            double[] bracket = new double[]{a, b};
            if (!BracketRoot.bracketRoot(bracket, function, maxIter, 1.6)) {
                throw new IllegalArgumentException("Cannot expand interval [x0,x1] to contain root.");
            }
            a = bracket[0];
            b = bracket[1];
            fa = function.f(a);
            fb = function.f(b);
        }
        double fc = fb;
        for (int iter = 1; iter <= maxIter; ++iter) {
            double tol1;
            double xm;
            if (fb > 0.0 && fc > 0.0 || fb < 0.0 && fc < 0.0) {
                c = a;
                fc = fa;
                e = d = b - a;
            }
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            if (iterationInformation != null) {
                iterationInformation.iterationInformation(b, fb, Double.NaN, iter);
            }
            if (convergenceTest.converged(xm = 0.5 * (c - b), 0.0, fb, tol1 = 2.0 * EPS * Math.abs(b) + 0.5 * tol, 0.0)) {
                return b;
            }
            if (Math.abs(e) >= tol1 && Math.abs(fa) > Math.abs(fb)) {
                double min2;
                double q;
                double p;
                double s = fb / fa;
                if (a == c) {
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                p = Math.abs(p);
                double min1 = 3.0 * xm * q - Math.abs(tol1 * q);
                double d2 = min1 < (min2 = Math.abs(e * q)) ? min1 : min2;
                if (2.0 * p < d2) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xm;
                }
            } else {
                e = d = xm;
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tol1 ? (b += d) : (b += xm > 0.0 ? tol1 : -tol1);
            fb = function.f(b);
        }
        return b;
    }

    public static double brent(double x0, double x1, double tol, int maxIter, MonadicFunction function) throws IllegalArgumentException {
        return Brent.brent(x0, x1, tol, maxIter, function, new StandardRootFinderConvergenceTest(), null);
    }

    public static double brent(double x0, double x1, MonadicFunction function) throws IllegalArgumentException {
        return Brent.brent(x0, x1, Constants.MACHEPS, 100, function, new StandardRootFinderConvergenceTest(), null);
    }

    @Override
    public double findRoot(double x0, double x1, double tol, int maxIter, MonadicFunction function, MonadicFunction derivativeFunction, RootFinderConvergenceTest convergenceTest, RootFinderIterationInformation iterationInformation) throws IllegalArgumentException {
        return Brent.brent(x0, x1, tol, maxIter, function, convergenceTest, iterationInformation);
    }
}

