/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.statistics;

import edu.northwestern.at.utils.math.matrix.ColumnTransformer;
import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixMeasure;
import edu.northwestern.at.utils.math.matrix.RowTransformer;
import edu.northwestern.at.utils.math.statistics.FishersExactTest;

public class ContingencyTable {
    public static double chisquare(Matrix table) {
        int rows = table.rows();
        int columns = table.columns();
        Matrix rowsums = RowTransformer.sum(table);
        Matrix colsums = ColumnTransformer.sum(table);
        double total = MatrixMeasure.sum(table);
        double result = 0.0;
        if (total > 0.0) {
            for (int row = 1; row <= rows; ++row) {
                for (int column = 1; column <= columns; ++column) {
                    double expected = colsums.get(1, column) * rowsums.get(row, 1) / total;
                    double ominuse = table.get(row, column) - expected;
                    result += ominuse * ominuse / expected;
                }
            }
        }
        return result;
    }

    protected static double logLikelihood(Matrix p, double total, Matrix k, int columns) {
        double sum = 0.0;
        double logtotal = Math.log(total);
        for (int column = 1; column <= columns; ++column) {
            if (p.get(1, column) == 0.0) continue;
            sum += k.get(1, column) * Math.log(p.get(1, column) / total);
        }
        return sum;
    }

    public static double likelihoodRatio(Matrix table) {
        int rows = table.rows();
        int columns = table.columns();
        Matrix rowsums = RowTransformer.sum(table);
        Matrix colsums = ColumnTransformer.sum(table);
        double total = MatrixMeasure.sum(table);
        double sum = 0.0;
        if (total > 0.0) {
            for (int row = 1; row <= rows; ++row) {
                sum += ContingencyTable.logLikelihood(table.getRow(row), rowsums.get(row, 1), table.getRow(row), columns) - ContingencyTable.logLikelihood(colsums, total, table.getRow(row), columns);
            }
        }
        return 2.0 * sum;
    }

    public static double[] fishersExactTest(Matrix table) {
        if (table.rows() != 2 || table.columns() != 2) {
            throw new RuntimeException("Table is not 2x2");
        }
        int n11 = (int)table.get(1, 1);
        int n12 = (int)table.get(1, 2);
        int n21 = (int)table.get(2, 1);
        int n22 = (int)table.get(2, 2);
        return FishersExactTest.fishersExactTest(n11, n12, n21, n22);
    }

    protected ContingencyTable() {
    }
}

