/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.statistics;

import edu.northwestern.at.utils.math.ArithUtils;
import edu.northwestern.at.utils.math.distributions.Gamma;
import java.util.ArrayList;
import java.util.Arrays;

public class Descriptive {
    protected Descriptive() {
    }

    public static double autoCorrelation(double[] data, int lag, double mean, double variance) {
        int N = data.length;
        if (lag >= N) {
            throw new IllegalArgumentException("Lag is too large");
        }
        double run = 0.0;
        for (int i = lag; i < N; ++i) {
            run += (data[i] - mean) * (data[i - lag] - mean);
        }
        return run / (double)(N - lag) / variance;
    }

    protected static void checkRangeFromTo(int from, int to, int theSize) {
        if (to == from - 1) {
            return;
        }
        if (from < 0 || from > to || to >= theSize) {
            throw new IndexOutOfBoundsException("from: " + from + ", to: " + to + ", size=" + theSize);
        }
    }

    public static double correlation(double[] data1, double standardDev1, double[] data2, double standardDev2) {
        return Descriptive.covariance(data1, data2) / (standardDev1 * standardDev2);
    }

    public static double covariance(double[] data1, double[] data2) {
        int size = data1.length;
        if (size != data2.length || size == 0) {
            throw new IllegalArgumentException();
        }
        double sumx = data1[0];
        double sumy = data2[0];
        double Sxy = 0.0;
        for (int i = 1; i < size; ++i) {
            double x = data1[i];
            double y = data2[i];
            Sxy += (x - (sumx += x) / (double)(i + 1)) * (y - sumy / (double)i);
            sumy += y;
        }
        return Sxy / (double)(size - 1);
    }

    private static double covariance2(double[] data1, double[] data2) {
        int size = data1.length;
        double mean1 = Descriptive.mean(data1);
        double mean2 = Descriptive.mean(data2);
        double covariance = 0.0;
        for (int i = 0; i < size; ++i) {
            double x = data1[i];
            double y = data2[i];
            covariance += (x - mean1) * (y - mean2);
        }
        return covariance / (double)(size - 1);
    }

    public static double durbinWatson(double[] data) {
        int size = data.length;
        if (size < 2) {
            throw new IllegalArgumentException("data sequence must contain at least two values.");
        }
        double run = 0.0;
        double run_sq = 0.0;
        run_sq = data[0] * data[0];
        for (int i = 1; i < size; ++i) {
            double x = data[i] - data[i - 1];
            run += x * x;
            run_sq += data[i] * data[i];
        }
        return run / run_sq;
    }

    public static void frequencies(double[] sortedData, ArrayList distinctValues, ArrayList frequencies) {
        distinctValues.clear();
        if (frequencies != null) {
            frequencies.clear();
        }
        int size = sortedData.length;
        int i = 0;
        while (i < size) {
            double element = sortedData[i];
            int cursor = i;
            while (++i < size && sortedData[i] == element) {
            }
            int runLength = i - cursor;
            distinctValues.add(new Double(element));
            if (frequencies == null) continue;
            frequencies.add(new Integer(runLength));
        }
    }

    public static double geometricMean(int size, double sumOfLogarithms) {
        return Math.exp(sumOfLogarithms / (double)size);
    }

    public static double geometricMean(double[] data) {
        return Descriptive.geometricMean(data.length, Descriptive.sumOfLogarithms(data, 0, data.length - 1));
    }

    public static double harmonicMean(int size, double sumOfInversions) {
        return (double)size / sumOfInversions;
    }

    public static void incrementalUpdate(double[] data, int from, int to, double[] inOut) {
        Descriptive.checkRangeFromTo(from, to, data.length);
        double min = inOut[0];
        double max = inOut[1];
        double sum = inOut[2];
        double sumSquares = inOut[3];
        while (from <= to) {
            double element = data[from];
            sum += element;
            sumSquares += element * element;
            if (element < min) {
                min = element;
            }
            if (element > max) {
                max = element;
            }
            ++from;
        }
        inOut[0] = min;
        inOut[1] = max;
        inOut[2] = sum;
        inOut[3] = sumSquares;
    }

    public static void incrementalUpdateSumsOfPowers(double[] data, int from, int to, int fromSumIndex, int toSumIndex, double[] sumOfPowers) {
        int size = data.length;
        int lastIndex = toSumIndex - fromSumIndex;
        if (from > size || lastIndex + 1 > sumOfPowers.length) {
            throw new IllegalArgumentException();
        }
        if (fromSumIndex == 1) {
            if (toSumIndex == 2) {
                double sum = sumOfPowers[0];
                double sumSquares = sumOfPowers[1];
                int i = from - 1;
                while (++i <= to) {
                    double element = data[i];
                    sum += element;
                    sumSquares += element * element;
                }
                sumOfPowers[0] = sumOfPowers[0] + sum;
                sumOfPowers[1] = sumOfPowers[1] + sumSquares;
                return;
            }
            if (toSumIndex == 3) {
                double sum = sumOfPowers[0];
                double sumSquares = sumOfPowers[1];
                double sum_xxx = sumOfPowers[2];
                int i = from - 1;
                while (++i <= to) {
                    double element = data[i];
                    sum += element;
                    sumSquares += element * element;
                    sum_xxx += element * element * element;
                }
                sumOfPowers[0] = sumOfPowers[0] + sum;
                sumOfPowers[1] = sumOfPowers[1] + sumSquares;
                sumOfPowers[2] = sumOfPowers[2] + sum_xxx;
                return;
            }
            if (toSumIndex == 4) {
                double sum = sumOfPowers[0];
                double sumSquares = sumOfPowers[1];
                double sum_xxx = sumOfPowers[2];
                double sum_xxxx = sumOfPowers[3];
                int i = from - 1;
                while (++i <= to) {
                    double element = data[i];
                    sum += element;
                    sumSquares += element * element;
                    sum_xxx += element * element * element;
                    sum_xxxx += element * element * element * element;
                }
                sumOfPowers[0] = sumOfPowers[0] + sum;
                sumOfPowers[1] = sumOfPowers[1] + sumSquares;
                sumOfPowers[2] = sumOfPowers[2] + sum_xxx;
                sumOfPowers[3] = sumOfPowers[3] + sum_xxxx;
                return;
            }
        }
        if (fromSumIndex == toSumIndex || fromSumIndex >= -1 && toSumIndex <= 5) {
            for (int i = fromSumIndex; i <= toSumIndex; ++i) {
                int n = i - fromSumIndex;
                sumOfPowers[n] = sumOfPowers[n] + Descriptive.sumOfPowerDeviations(data, i, 0.0, from, to);
            }
            return;
        }
        int i = from - 1;
        while (++i <= to) {
            double element = data[i];
            double pow = Math.pow(element, fromSumIndex);
            int j = 0;
            int m = lastIndex;
            while (--m >= 0) {
                int n = j++;
                sumOfPowers[n] = sumOfPowers[n] + pow;
                pow *= element;
            }
            int n = j;
            sumOfPowers[n] = sumOfPowers[n] + pow;
        }
    }

    public static void incrementalWeightedUpdate(double[] data, double[] weights, int from, int to, double[] inOut) {
        int dataSize = data.length;
        Descriptive.checkRangeFromTo(from, to, dataSize);
        if (dataSize != weights.length) {
            throw new IllegalArgumentException("from=" + from + ", to=" + to + ", data.length=" + dataSize + ", weights.length=" + weights.length);
        }
        double sum = inOut[0];
        double sumOfSquares = inOut[1];
        int i = from - 1;
        while (++i <= to) {
            double element = data[i];
            double weight = weights[i];
            double prod = element * weight;
            sum += prod;
            sumOfSquares += element * prod;
        }
        inOut[0] = sum;
        inOut[1] = sumOfSquares;
    }

    public static double kurtosis(double moment4, double standardDeviation) {
        return -3.0 + moment4 / (standardDeviation * standardDeviation * standardDeviation * standardDeviation);
    }

    public static double kurtosis(double[] data, double mean, double standardDeviation) {
        return Descriptive.kurtosis(Descriptive.moment(data, 4, mean), standardDeviation);
    }

    public static double lag1(double[] data, double mean) {
        int size = data.length;
        double q = 0.0;
        double v = (data[0] - mean) * (data[0] - mean);
        for (int i = 1; i < size; ++i) {
            double delta0 = data[i - 1] - mean;
            double delta1 = data[i] - mean;
            q += (delta0 * delta1 - q) / (double)(i + 1);
            v += (delta1 * delta1 - v) / (double)(i + 1);
        }
        double r1 = q / v;
        return r1;
    }

    public static double max(double[] data) {
        int size = data.length;
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        double max = data[size - 1];
        int i = size - 1;
        while (--i >= 0) {
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        return max;
    }

    public static double mean(double[] data) {
        return Descriptive.sum(data) / (double)data.length;
    }

    public static double meanDeviation(double[] data, double mean) {
        int size = data.length;
        double sum = 0.0;
        int i = size;
        while (--i >= 0) {
            sum += Math.abs(data[i] - mean);
        }
        return sum / (double)size;
    }

    public static double median(double[] sortedData) {
        return Descriptive.quantile(sortedData, 0.5);
    }

    public static double min(double[] data) {
        int size = data.length;
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        double min = data[size - 1];
        int i = size - 1;
        while (--i >= 0) {
            if (!(data[i] < min)) continue;
            min = data[i];
        }
        return min;
    }

    public static double moment(int k, double c, int size, double[] sumOfPowers) {
        double sum = 0.0;
        int sign = 1;
        for (int i = 0; i <= k; ++i) {
            double y = i == 0 ? 1.0 : (i == 1 ? c : (i == 2 ? c * c : (i == 3 ? c * c * c : Math.pow(c, i))));
            sum += (double)sign * ArithUtils.binomial(k, (long)i) * y * sumOfPowers[k - i];
            sign = -sign;
        }
        return sum / (double)size;
    }

    public static double moment(double[] data, int k, double c) {
        return Descriptive.sumOfPowerDeviations(data, k, c) / (double)data.length;
    }

    public static double pooledMean(int size1, double mean1, int size2, double mean2) {
        return ((double)size1 * mean1 + (double)size2 * mean2) / (double)(size1 + size2);
    }

    public static double pooledVariance(int size1, double variance1, int size2, double variance2) {
        return ((double)size1 * variance1 + (double)size2 * variance2) / (double)(size1 + size2);
    }

    public static double product(int size, double sumOfLogarithms) {
        return Math.pow(Math.exp(sumOfLogarithms / (double)size), size);
    }

    public static double product(double[] data) {
        int size = data.length;
        double product = 1.0;
        int i = size;
        while (--i >= 0) {
            product *= data[i];
        }
        return product;
    }

    public static double quantile(double[] sortedData, double phi) {
        int n = sortedData.length;
        double index = phi * (double)(n - 1);
        int lhs = (int)index;
        double delta = index - (double)lhs;
        if (n == 0) {
            return 0.0;
        }
        double result = lhs == n - 1 ? sortedData[lhs] : (1.0 - delta) * sortedData[lhs] + delta * sortedData[lhs + 1];
        return result;
    }

    public static double quantileInverse(double[] sortedList, double element) {
        return Descriptive.rankInterpolated(sortedList, element) / (double)sortedList.length;
    }

    public static double[] quantiles(double[] sortedData, double[] percentages) {
        int s = percentages.length;
        double[] quantiles = new double[s];
        for (int i = 0; i < s; ++i) {
            quantiles[i] = Descriptive.quantile(sortedData, percentages[i]);
        }
        return quantiles;
    }

    public static double rankInterpolated(double[] sortedList, double element) {
        int index = Arrays.binarySearch(sortedList, element);
        if (index >= 0) {
            int to;
            int s = sortedList.length;
            for (to = index + 1; to < s && sortedList[to] == element; ++to) {
            }
            return to;
        }
        int insertionPoint = -index - 1;
        if (insertionPoint == 0 || insertionPoint == sortedList.length) {
            return insertionPoint;
        }
        double from = sortedList[insertionPoint - 1];
        double to = sortedList[insertionPoint];
        double delta = (element - from) / (to - from);
        return (double)insertionPoint + delta;
    }

    public static double rms(int size, double sumOfSquares) {
        return Math.sqrt(sumOfSquares / (double)size);
    }

    public static double sampleKurtosis(int size, double moment4, double sampleVariance) {
        int n = size;
        double s2 = sampleVariance;
        double m4 = moment4 * (double)n;
        return m4 * (double)n * (double)(n + 1) / ((double)((n - 1) * (n - 2) * (n - 3)) * s2 * s2) - 3.0 * (double)(n - 1) * (double)(n - 1) / (double)((n - 2) * (n - 3));
    }

    public static double sampleKurtosis(double[] data, double mean, double sampleVariance) {
        return Descriptive.sampleKurtosis(data.length, Descriptive.moment(data, 4, mean), sampleVariance);
    }

    public static double sampleKurtosisStandardError(int size) {
        int n = size;
        return Math.sqrt(24.0 * (double)n * (double)(n - 1) * (double)(n - 1) / (double)((n - 3) * (n - 2) * (n + 3) * (n + 5)));
    }

    public static double sampleSkew(int size, double moment3, double sampleVariance) {
        int n = size;
        double s = Math.sqrt(sampleVariance);
        double m3 = moment3 * (double)n;
        return (double)n * m3 / ((double)((n - 1) * (n - 2)) * s * s * s);
    }

    public static double sampleSkew(double[] data, double mean, double sampleVariance) {
        return Descriptive.sampleSkew(data.length, Descriptive.moment(data, 3, mean), sampleVariance);
    }

    public static double sampleSkewStandardError(int size) {
        int n = size;
        return Math.sqrt(6.0 * (double)n * (double)(n - 1) / (double)((n - 2) * (n + 1) * (n + 3)));
    }

    public static double sampleStandardDeviation(int size, double sampleVariance) {
        int n = size;
        double s = Math.sqrt(sampleVariance);
        double Cn = n > 30 ? 1.0 + 1.0 / (double)(4 * (n - 1)) : Math.sqrt((double)(n - 1) * 0.5) * Gamma.gamma((double)(n - 1) * 0.5) / Gamma.gamma((double)n * 0.5);
        return Cn * s;
    }

    public static double sampleVariance(int size, double sum, double sumOfSquares) {
        double mean = sum / (double)size;
        return (sumOfSquares - mean * sum) / (double)(size - 1);
    }

    public static double sampleVariance(double[] data, double mean) {
        int size = data.length;
        double sum = 0.0;
        int i = size;
        while (--i >= 0) {
            double delta = data[i] - mean;
            sum += delta * delta;
        }
        return sum / (double)(size - 1);
    }

    public static double sampleWeightedVariance(double sumOfWeights, double sumOfProducts, double sumOfSquaredProducts) {
        return (sumOfSquaredProducts - sumOfProducts * sumOfProducts / sumOfWeights) / (sumOfWeights - 1.0);
    }

    public static double skew(double moment3, double standardDeviation) {
        return moment3 / (standardDeviation * standardDeviation * standardDeviation);
    }

    public static double skew(double[] data, double mean, double standardDeviation) {
        return Descriptive.skew(Descriptive.moment(data, 3, mean), standardDeviation);
    }

    public static ArrayList[] split(double[] sortedList, double[] splitters) {
        int noOfBins = splitters.length + 1;
        ArrayList[] bins = new ArrayList[noOfBins];
        int i = noOfBins;
        while (--i >= 0) {
            bins[i] = new ArrayList();
        }
        int listSize = sortedList.length;
        int nextStart = 0;
        for (int i2 = 0; nextStart < listSize && i2 < noOfBins - 1; ++i2) {
            double splitValue = splitters[i2];
            int index = Arrays.binarySearch(sortedList, splitValue);
            if (index < 0) {
                int insertionPosition = -index - 1;
                for (int j = nextStart; j < insertionPosition; ++j) {
                    bins[i2].add(new Double(sortedList[j]));
                }
                nextStart = insertionPosition;
                continue;
            }
            while (--index >= 0 && sortedList[index] == splitValue) {
            }
            for (int j = nextStart; j <= index; ++j) {
                bins[i2].add(new Double(sortedList[j]));
            }
            nextStart = index + 1;
        }
        for (int j = nextStart; j < sortedList.length; ++j) {
            bins[noOfBins - 1].add(new Double(sortedList[j]));
        }
        return bins;
    }

    public static double standardDeviation(double variance) {
        return Math.sqrt(variance);
    }

    public static double standardError(int size, double variance) {
        return Math.sqrt(variance / (double)size);
    }

    public static void standardize(double[] data, double mean, double standardDeviation) {
        int i = data.length;
        while (--i >= 0) {
            data[i] = (data[i] - mean) / standardDeviation;
        }
    }

    public static double sum(double[] data) {
        return Descriptive.sumOfPowerDeviations(data, 1, 0.0);
    }

    public static double sumOfInversions(double[] data, int from, int to) {
        return Descriptive.sumOfPowerDeviations(data, -1, 0.0, from, to);
    }

    public static double sumOfLogarithms(double[] data, int from, int to) {
        double logsum = 0.0;
        int i = from - 1;
        while (++i <= to) {
            logsum += Math.log(data[i]);
        }
        return logsum;
    }

    public static double sumOfPowerDeviations(double[] data, int k, double c) {
        return Descriptive.sumOfPowerDeviations(data, k, c, 0, data.length - 1);
    }

    public static double sumOfPowerDeviations(double[] data, int k, double c, int from, int to) {
        double sum = 0.0;
        switch (k) {
            case -2: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = data[i];
                        sum += 1.0 / (v * v);
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = data[i] - c;
                        sum += 1.0 / (v * v);
                    }
                }
                break;
            }
            case -1: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += 1.0 / data[i];
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += 1.0 / (data[i] - c);
                    }
                }
                break;
            }
            case 0: {
                sum += (double)(to - from + 1);
                break;
            }
            case 1: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += data[i];
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += data[i] - c;
                    }
                }
                break;
            }
            case 2: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = data[i];
                        sum += v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = data[i] - c;
                        sum += v * v;
                    }
                }
                break;
            }
            case 3: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = data[i];
                        sum += v * v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = data[i] - c;
                        sum += v * v * v;
                    }
                }
                break;
            }
            case 4: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = data[i];
                        sum += v * v * v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = data[i] - c;
                        sum += v * v * v * v;
                    }
                }
                break;
            }
            case 5: {
                if (c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = data[i];
                        sum += v * v * v * v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        double v = data[i] - c;
                        sum += v * v * v * v * v;
                    }
                }
                break;
            }
            default: {
                int i = from - 1;
                while (++i <= to) {
                    sum += Math.pow(data[i] - c, k);
                }
                break block0;
            }
        }
        return sum;
    }

    public static double sumOfPowers(double[] data, int k) {
        return Descriptive.sumOfPowerDeviations(data, k, 0.0);
    }

    public static double sumOfSquaredDeviations(int size, double variance) {
        return variance * (double)(size - 1);
    }

    public static double sumOfSquares(double[] data) {
        return Descriptive.sumOfPowerDeviations(data, 2, 0.0);
    }

    public static double trimmedMean(double[] sortedData, double mean, int left, int right) {
        int i;
        int N = sortedData.length;
        if (N == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (left + right >= N) {
            throw new IllegalArgumentException("Not enough data.");
        }
        int N0 = N;
        for (i = 0; i < left; ++i) {
            mean += (mean - sortedData[i]) / (double)(--N);
        }
        for (i = 0; i < right; ++i) {
            mean += (mean - sortedData[N0 - 1 - i]) / (double)(--N);
        }
        return mean;
    }

    public static double variance(double standardDeviation) {
        return standardDeviation * standardDeviation;
    }

    public static double variance(int size, double sum, double sumOfSquares) {
        double mean = sum / (double)size;
        return (sumOfSquares - mean * sum) / (double)size;
    }

    public static double weightedMean(double[] data, double[] weights) {
        int size = data.length;
        if (size != weights.length || size == 0) {
            throw new IllegalArgumentException();
        }
        double sum = 0.0;
        double weightsSum = 0.0;
        int i = size;
        while (--i >= 0) {
            double w = weights[i];
            sum += data[i] * w;
            weightsSum += w;
        }
        return sum / weightsSum;
    }

    public static double weightedRMS(double sumOfProducts, double sumOfSquaredProducts) {
        return sumOfProducts / sumOfSquaredProducts;
    }

    public static double winsorizedMean(double[] sortedData, double mean, int left, int right) {
        int N = sortedData.length;
        if (N == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (left + right >= N) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double leftElement = sortedData[left];
        for (int i = 0; i < left; ++i) {
            mean += (leftElement - sortedData[i]) / (double)N;
        }
        double rightElement = sortedData[N - 1 - right];
        for (int i = 0; i < right; ++i) {
            mean += (rightElement - sortedData[N - 1 - i]) / (double)N;
        }
        return mean;
    }
}

