/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.statistics;

import edu.northwestern.at.utils.Sorting;
import edu.northwestern.at.utils.math.matrix.Matrix;

public class RankOrder {
    public static void rankOrder(Matrix matrix) {
        int nCols = matrix.columns();
        int nRows = matrix.rows();
        for (int j = 1; j <= nCols; ++j) {
            matrix.setColumnData(j, RankOrder.getRankOrders(matrix.getColumnData(j)));
        }
    }

    public static double[] getRankOrders(double[] values) {
        int i;
        int j;
        int[] indices = new int[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            indices[i2] = i2;
        }
        Sorting.quickSort(values, indices, 0, values.length - 1);
        double[] rankOrders = new double[values.length];
        for (i = 0; i < values.length; i += j) {
            int k;
            j = 0;
            int l = 0;
            for (k = i; k < values.length; ++k) {
                if (values[k] != values[i]) continue;
                ++j;
                l = l + k + 1;
            }
            for (k = 0; k < j; ++k) {
                rankOrders[i + k] = (double)l / (double)j;
            }
        }
        for (i = 0; i < values.length; ++i) {
            values[indices[i]] = rankOrders[i];
        }
        return values;
    }

    protected RankOrder() {
    }
}

