/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.statistics;

import edu.northwestern.at.utils.math.distributions.Sig;
import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.statistics.Covar;
import edu.northwestern.at.utils.math.statistics.RankOrder;

public class SpearmanCorr {
    public static Matrix spearmanCorr(Matrix dataMatrix) {
        int nCols = dataMatrix.columns();
        int nRows = dataMatrix.rows();
        Matrix rankOrderDataMatrix = dataMatrix.getCopy();
        RankOrder.rankOrder(rankOrderDataMatrix);
        Matrix correlationMatrix = Covar.correlation(rankOrderDataMatrix);
        return correlationMatrix;
    }

    public static double sigSpearmanCorr(double r, int n) {
        double result = 0.0;
        double f = (1.0 - r) * (1.0 + r);
        if (f > 0.0) {
            double df = (double)n - 2.0;
            double t = r * Math.sqrt(df / f);
            result = Sig.t(t, df);
        }
        return result;
    }

    protected SpearmanCorr() {
    }
}

