/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.statistics;

import edu.northwestern.at.utils.math.matrix.Matrix;
import edu.northwestern.at.utils.math.matrix.MatrixFactory;

public class Standardize {
    public static Matrix[] standardize(Matrix matrix) {
        int nCols = matrix.columns();
        int nRows = matrix.rows();
        double nRowsm1 = (double)nRows - 1.0;
        Matrix columnMeans = MatrixFactory.createMatrix(1, nCols);
        Matrix columnStdDeviations = MatrixFactory.createMatrix(1, nCols);
        for (int j = 1; j <= nCols; ++j) {
            double mean = 0.0;
            for (int i = 1; i <= nRows; ++i) {
                mean += matrix.get(i, j);
            }
            if (nRows > 0) {
                mean /= (double)nRows;
            }
            columnMeans.set(1, j, mean);
            double sumSquares = 0.0;
            double centered = 0.0;
            for (int i = 1; i <= nRows; ++i) {
                centered = matrix.get(i, j) - mean;
                sumSquares += centered * centered;
            }
            double stdDeviation = 0.0;
            if (nRows > 1) {
                stdDeviation = Math.sqrt(sumSquares / (double)nRows);
            }
            columnStdDeviations.set(1, j, stdDeviation);
            if (stdDeviation == 0.0) continue;
            for (int i = 1; i <= nRows; ++i) {
                matrix.set(i, j, (matrix.get(i, j) - mean) / (Math.sqrt(nRows) * stdDeviation));
            }
        }
        Matrix[] result = new Matrix[]{columnMeans, columnStdDeviations};
        return result;
    }

    protected Standardize() {
    }
}

