/*
 * Decompiled with CFR 0.152.
 */
package com.owc.cache;

import com.owc.cache.CacheEntry;
import com.owc.cache.CacheEntryKey;
import com.owc.cache.CacheEntryMetaData;
import com.owc.cache.IOObjectCacheSerializer;
import com.owc.cache.streamers.DefaultIOObjectStreamer;
import com.owc.cache.streamers.IOObjectStreamer;
import com.owc.cache.streamers.NullIOObjectStreamer;
import com.rapidminer.extension.PluginInitJackhammerExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.tools.ParameterService;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;

public class CacheManager {
    private static Logger LOGGER = Logger.getGlobal();
    private static Map<Class<? extends IOObject>, IOObjectStreamer> streamerMap = new HashMap<Class<? extends IOObject>, IOObjectStreamer>();
    private static HTreeMap<CacheEntryKey, CacheEntry> cacheObjectMap;
    private static HTreeMap<CacheEntryKey, Integer> cacheObjectGenerationMap;
    private static HTreeMap<CacheEntryKey, CacheEntryMetaData> cacheMetadataMap;
    private static Object lock;
    private static boolean enableCache;

    public static synchronized void store(CacheEntryKey key, CacheEntry entry, int generationHash) {
        if (enableCache) {
            cacheObjectMap.put(key, entry);
            cacheObjectGenerationMap.put(key, generationHash);
            cacheMetadataMap.put(key, new CacheEntryMetaData(entry));
        }
    }

    public static CacheEntry retrieve(CacheEntryKey key) {
        if (enableCache) {
            return cacheObjectMap.get(key);
        }
        return null;
    }

    public static CacheEntryMetaData retrieveMetaData(CacheEntryKey key) {
        if (enableCache) {
            return cacheMetadataMap.get(key);
        }
        return null;
    }

    public static synchronized void remove(CacheEntryKey key) {
        if (enableCache) {
            cacheObjectMap.remove(key);
            cacheObjectGenerationMap.remove(key);
        }
    }

    public static int getNumberOfCacheEntries() {
        if (enableCache) {
            return cacheObjectMap.size();
        }
        return -1;
    }

    public static boolean checkCompatibility(CacheEntryKey key, int generationHash) {
        if (enableCache) {
            Integer integer = cacheObjectGenerationMap.get(key);
            return integer != null && integer == generationHash;
        }
        return false;
    }

    public static long getMaximumCacheSize() {
        try {
            return Integer.valueOf(ParameterService.getParameterValue((String)"rmx_toolkit.maximal_cache_size")) * 1024 * 1024;
        }
        catch (NumberFormatException e) {
            return 0x40000000L;
        }
    }

    static IOObjectStreamer getMostSpecificStreamer(IOObject object) {
        if (object == null) {
            return new NullIOObjectStreamer();
        }
        Class<?> targetClass = object.getClass();
        Class<? extends IOObject> bestClass = null;
        for (Map.Entry<Class<? extends IOObject>, IOObjectStreamer> entry : streamerMap.entrySet()) {
            Class<? extends IOObject> currentClass = entry.getKey();
            if (!currentClass.isAssignableFrom(targetClass) || bestClass != null && !bestClass.isAssignableFrom(currentClass)) continue;
            bestClass = currentClass;
        }
        return streamerMap.get(bestClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        lock = new Object();
        enableCache = true;
        Object object = lock;
        synchronized (object) {
            if (cacheObjectMap == null) {
                try {
                    File[] files;
                    File targetDirectory;
                    streamerMap.put(IOObject.class, new DefaultIOObjectStreamer());
                    DBMaker.Maker dbMaker = null;
                    DB cacheDB = null;
                    String directoryName = PluginInitJackhammerExtension.getParameterValue("rmx_toolkit.data_directory");
                    if ("".equals(directoryName) || directoryName == null) {
                        directoryName = System.getProperty("java.io.tmpdir");
                    }
                    if (!(targetDirectory = new File(directoryName)).exists()) {
                        targetDirectory.mkdirs();
                        LOGGER.log(Level.WARNING, "Jackhammer Extension: Creating Cache Directory '" + targetDirectory.toString() + "'.");
                    }
                    if ((files = targetDirectory.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isFile() && pathname.getName().matches("rm-toolkit-[0-9]*.cache");
                        }
                    })) != null) {
                        for (File file : files) {
                            try {
                                file.delete();
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                        }
                    }
                    dbMaker = DBMaker.fileDB(new File(targetDirectory, "rm-toolkit-" + System.currentTimeMillis() + ".cache"));
                    dbMaker.cacheLRUEnable().cacheSize(16).serializerClassLoader(CacheManager.class.getClassLoader());
                    if ("true".equals(PluginInitJackhammerExtension.getParameterValue("rmx_toolkit.use_memory_mapped_files"))) {
                        dbMaker.fileMmapEnableIfSupported();
                    }
                    dbMaker.closeOnJvmShutdown();
                    dbMaker.transactionDisable();
                    cacheDB = dbMaker.make();
                    cacheObjectMap = cacheDB.hashMapCreate("cache").counterEnable().expireStoreSize(CacheManager.getMaximumCacheSize()).executorEnable().executorEnable(Executors.newScheduledThreadPool(1)).executorPeriod(1000L).valueSerializer(new IOObjectCacheSerializer()).makeOrGet();
                    cacheObjectGenerationMap = cacheDB.hashMapCreate("generation-cache").makeOrGet();
                    cacheMetadataMap = cacheDB.hashMapCreate("metadata-cache").makeOrGet();
                }
                catch (Exception e) {
                    enableCache = false;
                    LOGGER.log(Level.SEVERE, "Jackhammer Extension: Disabled Cache due to error '" + e.getMessage() + "'.");
                }
            }
        }
    }
}

