/*
 * Decompiled with CFR 0.152.
 */
package com.owc.cache;

import com.owc.cache.CacheEntry;
import com.owc.cache.CacheManager;
import com.owc.cache.streamers.IOObjectStreamer;
import com.rapidminer.operator.IOObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.mapdb.Serializer;

final class IOObjectCacheSerializer
extends Serializer<CacheEntry> {
    IOObjectCacheSerializer() {
    }

    @Override
    public void serialize(final DataOutput out, CacheEntry value) throws IOException {
        out.writeLong(value.timestamp);
        out.writeInt(value.payload.size());
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                out.write(b);
            }
        };
        for (IOObject object : value.payload) {
            IOObjectStreamer streamer = CacheManager.getMostSpecificStreamer(object);
            new ObjectOutputStream(outputStream).writeObject(streamer);
            streamer.write(outputStream, object);
        }
    }

    @Override
    public CacheEntry deserialize(final DataInput in, int available) throws IOException {
        long timestamp = in.readLong();
        InputStream inputStream = new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    return in.readUnsignedByte();
                }
                catch (EOFException e) {
                    return -1;
                }
            }
        };
        LinkedList<IOObject> payload = new LinkedList<IOObject>();
        int numberOfPayload = in.readInt();
        for (int i = 0; i < numberOfPayload; ++i) {
            IOObjectStreamer streamer;
            try {
                streamer = (IOObjectStreamer)new ObjectInputStream(inputStream).readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Incompatible Streamer found. Likely written by higher version", e);
            }
            IOObject payloadEntry = streamer.read(inputStream);
            payload.add(payloadEntry);
        }
        return new CacheEntry(payload, timestamp);
    }
}

