/*
 * Decompiled with CFR 0.152.
 */
package com.owc.data.exampleset;

import com.owc.data.exampleset.ExampleComparator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.UserError;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.lang.ArrayUtils;

public class SortedExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = 1482422148934385825L;
    public static final String[] SORTING_DIRECTIONS = new String[]{"increasing", "decreasing"};
    public static final int INCREASING = 1;
    public static final int DECREASING = -1;
    private ExampleSet parentSet;
    private int[] sortedIndices;

    public SortedExampleSet(ExampleSet parent, final int[] sortingDirectionOfSpecificAttribute, final boolean enableLexicographicSorting, final Attribute ... sortingAttributes) {
        this.parentSet = (ExampleSet)parent.clone();
        Integer[] sortedIndices = new Integer[this.parentSet.size()];
        for (int i = 0; i < this.parentSet.size(); ++i) {
            sortedIndices[i] = i;
        }
        Arrays.sort(sortedIndices, new Comparator<Integer>(){
            private final ExampleComparator exampleComparator;
            {
                this.exampleComparator = new ExampleComparator(sortingDirectionOfSpecificAttribute, enableLexicographicSorting, sortingAttributes, sortingAttributes);
            }

            @Override
            public int compare(Integer index1, Integer index2) {
                Example o1 = SortedExampleSet.this.parentSet.getExample(index1.intValue());
                Example o2 = SortedExampleSet.this.parentSet.getExample(index2.intValue());
                return this.exampleComparator.compare(o1, o2);
            }
        });
        this.sortedIndices = ArrayUtils.toPrimitive((Integer[])sortedIndices);
    }

    public SortedExampleSet(ExampleSet parent, int sortingDirection, boolean enableLexicographicSorting, Attribute ... sortingAttributes) {
        this(parent, SortedExampleSet.createArray(sortingDirection, sortingAttributes.length), enableLexicographicSorting, sortingAttributes);
    }

    private static int[] createArray(int sortingDirection, int length) {
        int[] sortingDirections = new int[length];
        Arrays.fill(sortingDirections, sortingDirection);
        return sortingDirections;
    }

    public SortedExampleSet(ExampleSet parent, int sortingDirection, boolean enableLexicographicSorting, String ... sortingAttributeNames) throws UserError {
        this(parent, sortingDirection, enableLexicographicSorting, SortedExampleSet.getSelectedAttributes(parent, sortingAttributeNames));
    }

    private static Attribute[] getSelectedAttributes(ExampleSet parent, String ... sortingAttributeNames) throws UserError {
        Attribute[] selectedAttributes = new Attribute[sortingAttributeNames.length];
        Attributes parentAttributes = parent.getAttributes();
        int i = 0;
        for (String attributeName : sortingAttributeNames) {
            if (i < selectedAttributes.length) {
                Attribute selectedAttribute = parentAttributes.get(attributeName);
                if (selectedAttribute == null) {
                    throw new UserError(null, 160, new Object[]{attributeName});
                }
                selectedAttributes[i] = selectedAttribute;
            }
            ++i;
        }
        return selectedAttributes;
    }

    public SortedExampleSet(SortedExampleSet exampleSet) {
        this.parentSet = (ExampleSet)exampleSet.parentSet.clone();
        if (exampleSet.sortedIndices != null) {
            this.sortedIndices = new int[exampleSet.sortedIndices.length];
            System.arraycopy(exampleSet.sortedIndices, 0, this.sortedIndices, 0, exampleSet.sortedIndices.length);
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SortedExampleSet)) {
            return false;
        }
        SortedExampleSet other = (SortedExampleSet)((Object)o);
        if (this.sortedIndices.length != other.sortedIndices.length) {
            return false;
        }
        for (int i = 0; i < this.sortedIndices.length; ++i) {
            if (this.parentSet.getExample(this.sortedIndices[i]).equals(other.parentSet.getExample(this.sortedIndices[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int sortHash = Arrays.hashCode(this.sortedIndices);
        return super.hashCode() ^ sortHash;
    }

    public Iterator<Example> iterator() {
        return new Iterator<Example>(){
            private int counter = 0;

            @Override
            public boolean hasNext() {
                return this.counter < SortedExampleSet.this.sortedIndices.length;
            }

            @Override
            public Example next() {
                Example currentExample = SortedExampleSet.this.parentSet.getExample(SortedExampleSet.this.sortedIndices[this.counter]);
                ++this.counter;
                return currentExample;
            }
        };
    }

    public Example getExample(int index) {
        return this.parentSet.getExample(this.sortedIndices[index]);
    }

    public int size() {
        return this.sortedIndices.length;
    }

    public Attributes getAttributes() {
        return this.parentSet.getAttributes();
    }

    public Annotations getAnnotations() {
        return this.parentSet.getAnnotations();
    }

    public ExampleTable getExampleTable() {
        return this.parentSet.getExampleTable();
    }

    public void cleanup() {
        this.parentSet.cleanup();
    }
}

