/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.renderer;

import com.owc.objects.files.RemoteFileObject;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.report.Reportable;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class RemoteFileObjectRenderer
extends AbstractRenderer
implements Reportable {
    public String getName() {
        return "Remote File Object";
    }

    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        if (!(renderable instanceof RemoteFileObject)) {
            throw new RuntimeException("Only RemoteFileObjects can be displayed here!");
        }
        JPanel component = new JPanel(new BorderLayout());
        component.setBackground(Colors.WHITE);
        RemoteFileObject remoteFileObject = (RemoteFileObject)((Object)renderable);
        ExtendedJTable table = new ExtendedJTable((TableModel)new RemoteFileObjectTableModel(remoteFileObject), false);
        table.setRowHeight(32);
        table.setRowHighlighting(true);
        table.setSortable(false);
        table.getTableHeader().setReorderingAllowed(false);
        table.getTableHeader().setVisible(false);
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane((Component)table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(50, 20, 15, 20));
        scrollPane.setBackground(Colors.WHITE);
        scrollPane.getViewport().setBackground(Colors.WHITE);
        component.add((Component)scrollPane, "Center");
        return component;
    }

    public Reportable createReportable(Object renderable, IOContainer ioContainer, int desiredWidth, int desiredHeight) {
        return this;
    }

    private static final class RemoteFileObjectTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2154360751437450749L;
        RemoteFileObject remoteFile = null;
        private String fileNameAttribute = "Filename";
        private String fileRemoteUrlAttribute = "RemoteUrl";
        private String remoteFileLocationAttribute = "Remote Location";
        private String[][] fileInfo = null;

        public RemoteFileObjectTableModel(RemoteFileObject remoteFile) {
            this.remoteFile = remoteFile;
            this.loadData();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.fileInfo.length;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.fileInfo[row][column];
        }

        private void loadData() {
            String publicUri = "";
            publicUri = "" + this.remoteFile.getVfsFileObject().getPublicURIString();
            this.fileInfo = new String[][]{{this.fileNameAttribute, this.remoteFile.getFilename()}, {this.remoteFileLocationAttribute, this.remoteFile.getSource()}, {this.fileRemoteUrlAttribute, publicUri}};
        }
    }
}

