/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.tools;

import com.sun.javafx.application.PlatformImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SwingWebView
extends JPanel {
    private static final long serialVersionUID = 3616543689275215748L;
    private Stage stage;
    private WebView browser;
    private JFXPanel jfxPanel;
    private JButton reloadWebpageButton;
    private WebEngine webEngine;
    private String url;
    private String content;
    private String title;
    private static boolean listenerRegistered = false;

    public SwingWebView(String title, String content) {
        this(title, null, content);
    }

    public SwingWebView(String title, URL url) {
        this(title, url, null);
    }

    private SwingWebView(String title, URL url, String content) {
        this.title = title;
        this.url = url == null ? "" : url.toString();
        this.content = content;
        this.jfxPanel = new JFXPanel();
        this.createScene();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jfxPanel, "Center");
        this.reloadWebpageButton = new JButton();
        this.reloadWebpageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (SwingWebView.this.webEngine != null) {
                            SwingWebView.this.webEngine.reload();
                        }
                    }
                });
            }
        });
        this.reloadWebpageButton.setText("Reload");
        JSlider slider = new JSlider(0, 0, 200, 100);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(final ChangeEvent e) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (SwingWebView.this.browser == null) {
                            return;
                        }
                        JSlider source = (JSlider)e.getSource();
                        if (!source.getValueIsAdjusting()) {
                            SwingWebView.this.browser.setZoom((double)source.getValue() / 100.0);
                        }
                    }
                });
            }
        });
        JPanel footer = new JPanel(new BorderLayout());
        footer.add((Component)slider, "West");
        footer.add((Component)this.reloadWebpageButton, "Center");
        this.add((Component)footer, "South");
    }

    private void createScene() {
        SwingWebView.registerListenerToJavaFXThread();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BorderPane pane = new BorderPane();
                Scene scene = new Scene((Parent)pane);
                SwingWebView.this.browser = new WebView();
                BorderPane.setAlignment((Node)SwingWebView.this.browser, (Pos)Pos.CENTER);
                pane.setCenter((Node)SwingWebView.this.browser);
                SwingWebView.this.webEngine = SwingWebView.this.browser.getEngine();
                if (SwingWebView.this.content != null) {
                    SwingWebView.this.webEngine.loadContent(SwingWebView.this.content);
                } else {
                    SwingWebView.this.webEngine.load(SwingWebView.this.url);
                }
                SwingWebView.this.jfxPanel.setScene(scene);
                SwingWebView.this.jfxPanel.revalidate();
            }
        });
    }

    private static synchronized void registerListenerToJavaFXThread() {
        if (!listenerRegistered) {
            PlatformImpl.addListener((PlatformImpl.FinishListener)new PlatformImpl.FinishListener(){

                public void idle(boolean implicitExit) {
                }

                public void exitCalled() {
                }
            });
            listenerRegistered = true;
        }
    }
}

