/*
 * Decompiled with CFR 0.152.
 */
package com.owc.license;

import com.owc.license.LicenseEncryption;
import com.owc.license.VersionHistory;
import com.owc.license.io.ChunkingInputStream;
import com.owc.license.io.PersistentOutputStream;
import com.rapidminer.gui.tools.VersionNumber;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class License
implements Serializable {
    private static final long serialVersionUID = 4710080402972199445L;
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String DATE_PERPETUAL_STRING = "0000-01-01";
    private String licenseDateStart;
    private String licenseDateEnd;
    private String maintenanceDateEnd;
    private String emailPatternString;
    private String productPatternString;

    License(String licenseDateStart, String licenseDateEnd, String maintenanceDateEnd, String emailPattern, String productPattern) {
        this.licenseDateStart = licenseDateStart;
        this.licenseDateEnd = licenseDateEnd;
        this.maintenanceDateEnd = maintenanceDateEnd;
        this.emailPatternString = emailPattern;
        this.productPatternString = productPattern;
    }

    public License(InputStream publicKeyInputStream, String licenseKey) throws IOException {
        this(publicKeyInputStream, (InputStream)new ByteArrayInputStream(licenseKey.getBytes(StandardCharsets.UTF_8)));
    }

    public License(InputStream publicKeyInputStream, InputStream stream) throws IOException {
        ChunkingInputStream chunkingStream = new ChunkingInputStream(stream, 42);
        try {
            LicenseEncryption encryption = new LicenseEncryption();
            encryption.loadPublicKey(publicKeyInputStream);
            encryption.loadSymetricKey(chunkingStream);
            chunkingStream.next();
            this.licenseDateStart = encryption.loadData(chunkingStream);
            chunkingStream.next();
            this.licenseDateEnd = encryption.loadData(chunkingStream);
            chunkingStream.next();
            this.maintenanceDateEnd = encryption.loadData(chunkingStream);
            chunkingStream.next();
            this.emailPatternString = encryption.loadData(chunkingStream);
            chunkingStream.next();
            this.productPatternString = encryption.loadData(chunkingStream);
            chunkingStream.closeFinal();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
    }

    public License(PublicKey publicKey, String licenseKey) throws IOException {
        this(publicKey, (InputStream)new ByteArrayInputStream(licenseKey.getBytes(StandardCharsets.UTF_8)));
    }

    public License(PublicKey publicKey, InputStream stream) throws IOException {
        ChunkingInputStream chunkingStream = new ChunkingInputStream(stream, 42);
        try {
            LicenseEncryption encryption = new LicenseEncryption();
            encryption.setPublicKey(publicKey);
            encryption.loadSymetricKey(chunkingStream);
            chunkingStream.next();
            this.licenseDateStart = encryption.loadData(chunkingStream);
            chunkingStream.next();
            this.licenseDateEnd = encryption.loadData(chunkingStream);
            chunkingStream.next();
            this.maintenanceDateEnd = encryption.loadData(chunkingStream);
            chunkingStream.next();
            this.emailPatternString = encryption.loadData(chunkingStream);
            chunkingStream.next();
            this.productPatternString = encryption.loadData(chunkingStream);
            chunkingStream.closeFinal();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
    }

    public void writeLicense(InputStream privateKeyInputStream, OutputStream stream) throws IOException, GeneralSecurityException {
        PersistentOutputStream persistentStream = new PersistentOutputStream(stream);
        LicenseEncryption encryption = new LicenseEncryption();
        encryption.loadPrivateKey(privateKeyInputStream);
        encryption.appendSymetricKey(persistentStream);
        persistentStream.write(42);
        encryption.appendData(this.licenseDateStart, persistentStream);
        persistentStream.write(42);
        encryption.appendData(this.licenseDateEnd, persistentStream);
        persistentStream.write(42);
        encryption.appendData(this.maintenanceDateEnd, persistentStream);
        persistentStream.write(42);
        encryption.appendData(this.emailPatternString, persistentStream);
        persistentStream.write(42);
        encryption.appendData(this.productPatternString, persistentStream);
        persistentStream.closeFinal();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("License Date Start: " + this.licenseDateStart);
        buffer.append("\nLicense Date End: " + this.licenseDateEnd);
        buffer.append("\nMaintenance End: " + this.licenseDateEnd);
        buffer.append("\nEmail Pattern: " + this.emailPatternString);
        buffer.append("\nProduct Pattern: " + this.productPatternString);
        return buffer.toString();
    }

    public boolean isValid(String productKey, String email) {
        try {
            Pattern productPattern;
            Pattern mailPattern;
            Date startDate = DATE_FORMAT.parse(this.licenseDateStart);
            Date endDate = DATE_FORMAT.parse(this.licenseDateEnd);
            Date now = new Date();
            boolean isPerpetualLicense = this.licenseDateEnd.equals(DATE_PERPETUAL_STRING);
            if (startDate.before(now) && (endDate.after(now) || isPerpetualLicense) && (mailPattern = Pattern.compile(this.emailPatternString)).matcher(email).matches() && (productPattern = Pattern.compile(this.productPatternString)).matcher(productKey).matches()) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }

    public boolean isMaintained(VersionNumber productVersion, VersionHistory versionHistory) {
        try {
            Date endDate = DATE_FORMAT.parse(this.maintenanceDateEnd);
            Date publicationDate = versionHistory.getPublicationDate(productVersion);
            return publicationDate == null || publicationDate.before(endDate);
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

