/*
 * Decompiled with CFR 0.152.
 */
package com.owc.license;

import com.owc.license.License;
import com.owc.license.ProductInformation;
import com.owc.license.VersionHistory;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.ParameterService;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicenseManager {
    public static final String PARAMETER_SUFFIX_EMAIL = ".email";
    public static final String PARAMETER_SUFFIX_LICENSE_KEY = ".license_key";
    private static final Set<String> MANAGED_PRODUCTS = new HashSet<String>();
    private static final HashMap<String, License> PRODUCT_LICENSES = new HashMap();
    private static final HashMap<String, VersionHistory> PRODUCT_HISTORIES = new HashMap();
    private static final HashMap<String, VersionNumber> PRODUCT_VERSIONS = new HashMap();
    private static final HashMap<String, ProductInformation> PRODUCT_INFORMATIONS = new HashMap();
    private static final Set<String> VALID_AND_MAINTAINED_PRODUCTS = new HashSet<String>();
    private static final Set<String> VALID_PRODUCTS = new HashSet<String>();
    private static Logger LOGGER = Logger.getLogger(LicenseManager.class.getName());

    public static void registerParameters(String productName) {
        ParameterService.registerParameter((ParameterType)new ParameterTypeString(productName + PARAMETER_SUFFIX_LICENSE_KEY, "This is the license key you received after purchasing this extension."), (String)"Licenses");
        ParameterService.registerParameter((ParameterType)new ParameterTypeString(productName + PARAMETER_SUFFIX_EMAIL, "This is the email address you registered this extension for. Please not that only the correct combination of license key and email will work."), (String)"Licenses");
    }

    public static void manageProduct(ProductInformation productInformation, VersionNumber productVersion, VersionHistory versionHistory) {
        String productName = productInformation.getProductName();
        MANAGED_PRODUCTS.add(productName);
        PRODUCT_HISTORIES.put(productName, versionHistory);
        PRODUCT_VERSIONS.put(productName, productVersion);
        PRODUCT_INFORMATIONS.put(productName, productInformation);
        LicenseManager.update(productName);
    }

    public static void update(String productName) {
        String licenseKey = LicenseManager.getLicenseKey(productName);
        String emailAddress = LicenseManager.getEmailAddress(productName);
        if (!licenseKey.isEmpty()) {
            try {
                License license = new License(PRODUCT_INFORMATIONS.get(productName).getProductPublicKey(), licenseKey);
                PRODUCT_LICENSES.put(productName, license);
                if (license.isValid(productName, emailAddress)) {
                    System.out.println(productName + ": License Valid");
                    LOGGER.log(Level.INFO, productName + ": License Valid");
                    VALID_PRODUCTS.add(productName);
                    if (license.isMaintained(PRODUCT_VERSIONS.get(productName), PRODUCT_HISTORIES.get(productName))) {
                        VALID_AND_MAINTAINED_PRODUCTS.add(productName);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getEmailAddress(String productName) {
        String emailAddress = ParameterService.getParameterValue((String)(productName + PARAMETER_SUFFIX_EMAIL));
        if (emailAddress == null || emailAddress.isEmpty()) {
            emailAddress = ParameterService.getParameterValue((String)("rapidminer." + productName + PARAMETER_SUFFIX_EMAIL));
            System.out.println(productName + ": Using Server-FallBack for Licensee...");
            LOGGER.log(Level.INFO, productName + ": Using Server-FallBack for Licensee...");
        }
        if (emailAddress == null || emailAddress.isEmpty()) {
            System.out.println(productName + ": No Licensee Email found!");
            LOGGER.log(Level.WARNING, productName + ": No Licensee Email found!");
        } else {
            System.out.println(productName + ": Found Licensee Email '" + emailAddress + "'");
            LOGGER.log(Level.INFO, productName + ": Found Licensee Email '" + emailAddress + "'");
        }
        return emailAddress;
    }

    public static String getLicenseKey(String productName) {
        StringBuilder builder = new StringBuilder();
        String licenseKeyFragment = ParameterService.getParameterValue((String)(productName + PARAMETER_SUFFIX_LICENSE_KEY));
        if (licenseKeyFragment == null || licenseKeyFragment.isEmpty()) {
            licenseKeyFragment = ParameterService.getParameterValue((String)("rapidminer." + productName + PARAMETER_SUFFIX_LICENSE_KEY));
            System.out.println(productName + ": Using Server-FallBack for License Key...");
            LOGGER.log(Level.INFO, productName + ": Using Server-FallBack for License Key...");
        }
        for (int i = 1; licenseKeyFragment != null || i == 1; ++i) {
            if (licenseKeyFragment != null) {
                builder.append(licenseKeyFragment.trim());
            }
            if (((licenseKeyFragment = ParameterService.getParameterValue((String)(productName + PARAMETER_SUFFIX_LICENSE_KEY + "_" + i))) == null || licenseKeyFragment.isEmpty()) && (licenseKeyFragment = ParameterService.getParameterValue((String)("rapidminer." + productName + PARAMETER_SUFFIX_LICENSE_KEY + "_" + i))) != null && !licenseKeyFragment.isEmpty()) {
                System.out.println(productName + ": Using Server-Fallback for License Key Fragments...");
                LOGGER.log(Level.INFO, productName + ": Using Server-Fallback for License Key Fragments...");
            }
            if (licenseKeyFragment == null || licenseKeyFragment.isEmpty()) continue;
            System.out.println(productName + ": Found " + i + ". License Key Fragment");
            LOGGER.log(Level.INFO, productName + ": Found " + i + ". License Key Fragment");
        }
        String licenseKey = builder.toString();
        if (licenseKey != null && !licenseKey.isEmpty()) {
            if (licenseKey.length() > 6) {
                System.out.println(productName + ": Found License Key '" + licenseKey.substring(0, 5) + "...'");
                LOGGER.log(Level.INFO, productName + ": Found License Key '" + licenseKey.substring(0, 5) + "...'");
            } else {
                System.out.println(productName + ": Found License Key '" + licenseKey + "'");
                LOGGER.log(Level.INFO, productName + ": Found License Key '" + licenseKey + "'");
            }
        } else {
            System.out.println(productName + ": No License Key found!");
            LOGGER.log(Level.WARNING, productName + ": No License Key found!");
        }
        return licenseKey;
    }

    public static boolean isLicenseValid(String productName) {
        return VALID_PRODUCTS.contains(productName);
    }

    public static License getLicense(String productName) {
        return PRODUCT_LICENSES.get(productName);
    }

    public static boolean isLicenseValidAndMaintained(String productName) {
        return VALID_AND_MAINTAINED_PRODUCTS.contains(productName);
    }
}

