/*
 * Decompiled with CFR 0.152.
 */
package com.owc.metadata;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPortExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class UnionExampleSetsRule
implements MDTransformationRule {
    private final InputPortExtender inputPortExtender;
    private final InputPort[] inputPorts;
    private final OutputPort outputPort;
    private String suffixForDuplicates;
    private boolean failOnDifferentTypes;
    private final Operator operator;
    private String parameterNameSuffix;
    private String parameterNameDifferentTypes;

    public UnionExampleSetsRule(InputPortExtender inputPortExtender, OutputPort outputPort, String suffixForDuplicates, InputPort ... inputPorts) {
        this.inputPortExtender = inputPortExtender;
        this.inputPorts = inputPorts;
        this.outputPort = outputPort;
        this.suffixForDuplicates = suffixForDuplicates;
        this.failOnDifferentTypes = false;
        this.operator = null;
    }

    public UnionExampleSetsRule(Operator operator, String parameterNameSuffix, String parameterNameDifferentTypes, InputPortExtender inputPortExtender, OutputPort outputPort, InputPort ... inputPorts) {
        this.inputPortExtender = inputPortExtender;
        this.inputPorts = inputPorts;
        this.outputPort = outputPort;
        this.operator = operator;
        this.parameterNameDifferentTypes = parameterNameDifferentTypes;
        this.parameterNameSuffix = parameterNameSuffix;
    }

    public void transformMD() {
        if (this.operator != null) {
            try {
                this.suffixForDuplicates = this.operator.getParameterAsString(this.parameterNameSuffix);
            }
            catch (UndefinedParameterError e) {
                this.suffixForDuplicates = " set suffix ";
            }
            this.failOnDifferentTypes = this.parameterNameDifferentTypes != null ? this.operator.getParameterAsBoolean(this.parameterNameDifferentTypes) : false;
        }
        List metaDatas = this.inputPortExtender != null ? this.inputPortExtender.getMetaData(true) : new LinkedList();
        if (this.inputPorts != null) {
            for (InputPort inputPort : this.inputPorts) {
                metaDatas.add(inputPort.getMetaData());
            }
        }
        Integer one = new Integer(1);
        ExampleSetMetaData unionedEmd = new ExampleSetMetaData();
        HashMap<String, Integer> attributeNames = new HashMap<String, Integer>();
        HashMap renamedNamesMappedToOriginialName = new HashMap();
        HashMap<String, AttributeMetaData> mappedAttributes = new HashMap<String, AttributeMetaData>();
        for (MetaData metaData : metaDatas) {
            if (metaData == null || !(metaData instanceof ExampleSetMetaData)) continue;
            ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
            for (AttributeMetaData amd : emd.getAllAttributes()) {
                Integer suffixCounter = (Integer)attributeNames.get(amd.getName());
                if (suffixCounter == null) {
                    attributeNames.put(amd.getName(), one);
                    unionedEmd.addAttribute(amd);
                    mappedAttributes.put(amd.getName(), amd);
                    LinkedHashSet renamedNames = new LinkedHashSet();
                    renamedNamesMappedToOriginialName.put(amd.getName(), renamedNames);
                    continue;
                }
                if (unionedEmd.getAttributeByName(amd.getName()).getValueType() == amd.getValueType()) continue;
                boolean addAttribute = true;
                HashSet<String> renamedNames = (HashSet<String>)renamedNamesMappedToOriginialName.get(amd.getName());
                if (renamedNames == null) {
                    renamedNames = new HashSet<String>();
                }
                for (String renamedName : renamedNames) {
                    if (((AttributeMetaData)mappedAttributes.get(renamedName)).getValueType() != amd.getValueType()) continue;
                    addAttribute = false;
                }
                if (!addAttribute) continue;
                if (this.failOnDifferentTypes) {
                    if (this.operator == null) continue;
                    this.operator.addError((ProcessSetupError)new SimpleProcessSetupError(ProcessSetupError.Severity.ERROR, this.operator.getPortOwner(), "toolkit.union_incompatible_attribute_types", new Object[0]));
                    continue;
                }
                attributeNames.put(amd.getName(), suffixCounter + 1);
                amd = amd.clone();
                amd.setName(amd.getName() + this.suffixForDuplicates + suffixCounter);
                unionedEmd.addAttribute(amd);
                renamedNames.add(amd.getName());
                mappedAttributes.put(amd.getName(), amd);
            }
        }
        this.outputPort.deliverMD((MetaData)this.finalTransform(unionedEmd));
    }

    protected ExampleSetMetaData finalTransform(ExampleSetMetaData emd) {
        return emd;
    }
}

